package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

import java.util.List;

/**
 * 同步计费服务
 * <p>
 * https://api-mock.xforceplus.com/project/141/interface/api/44128
 */
public class PostSupportServiceMessage {

    @Data
    public static class Request {

        /**
         * 租户id（3.0平台为租户code）
         */
        private String tenantId;

        /**
         * 租户名称
         */
        private String tenantName;

        /**
         * 税号
         */
        private String taxNo;

        /**
         * 公司名称
         */
        private String companyName;

        /**
         * 服务列表
         */
        private List<String> serviceNameList;

        /**
         * 服务状态（enable：启用 disabled：停用，不传查询所有状态）
         */
        private String serviceStatus;

    }

    @Data
    public static class Response {

        /**
         * 返回码（1为成功 其余为失败）
         */
        private String code = "1";

        /**
         * 返回信息
         */
        private String message = "成功";

        /**
         * 追踪码
         */
        private String traceId;
    }
}
