package com.xforceplus.taxware.contract.allelectric.message;

import com.xforceplus.taxware.contract.allelectric.message.common.OpenApiBaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author Thj
 * @createdAt: 2022/10/9 14:28
 * @Description: V2全电纸票开具接口(异步批量)
 * https://api-mock.xforceplus.com/project/136/interface/api/42586
 * 优惠政策枚举值详见 ： https://xforceplus.yuque.com/dew9bm/yagacb/qwzueume97ouom15
 */
public class V2BatchPostInvoiceMessage {

    @Data
    public static class Request {
        private String taskId;
        private String mode = "issue";
        private Boolean isErrorContinue;

        /**
         * 开票人
         **/
        private String issuer;

        /**
         * 是否自动选择开票人标识（不传默认为false，如果传为true，则由税件自行选择开具的开票人）
         */
        private Boolean isAutoSelectIssuerFlag;

        /**
         * 是否乐企标识（不传默认为false，如果传为true，走乐企通道）
         */
        private Boolean isNaturalSystemFlag;

        /**
         * 渠道
         */
        private String channel;

        /**
         * 下一张发票信息（仅纸票需要）
         */
        private NextInvoiceInfo nextInvoice;

        @Data
        public static class NextInvoiceInfo {
            private String invoiceCode;
            private String invoiceNo;
        }

        /**
         * 预制发票列表（单次限定最大300张）
         */
        private List<PreInvoice> preInvoiceList;

        @Data
        public static class PreInvoice {
            /**
             * 预制发票id
             **/
            private String pid;

            /**
             * 发票类型
             * cz:全电纸质普票 sz:全电纸质专票 qc:全电电子普票 qs:全电电子专票
             **/
            private String invoiceType;

            /**
             * 是否销货清单（电票默认false）
             */
            private Boolean isSalesList;

            /**
             * 特定要素类型代码（仅全电电票支持）
             * (枚举值详见
             * https://xforceplus.yuque.com/dew9bm/yagacb/qwzueume97ouom15
             * 一、全电特定业务枚举)
             **/
            private String invoiceStyleType;

            /**
             * 追踪信息
             **/
            private TraceInfo trace;

            @Data
            public static class TraceInfo {

                /**
                 * 单据编号
                 **/
                private String receiptNo;
            }

            /**
             * 开票控制项
             */
            private InvoiceControl control;

            @Data
            public static class InvoiceControl {

                /**
                 * 版式文件控制项
                 */
                private Integer voucherControl;

                /**
                 * 是否校验销方地址电话银行信息控制项
                 */
                private Boolean validateSellerInfoControl;

                /**
                 * 差额开票枚举项
                 * 空：不适用差额征税
                 * difference：差额征税差额开票
                 * full：差额征税全额开票
                 */
                private String taxDifferenceFlag;

                /**
                 * 是否展示购方银行控制项(当值为true 会在备注展示购方银行信息)
                 */
                private Boolean showBuyerBankControl;

                /**
                 * 是否展示销方银行控制项(当值为true 会在备注展示销方银行信息)
                 */
                private Boolean showSellerBankControl;
            }

            /**
             * 销方信息
             **/
            private SellerInfo seller;

            @Data
            public static class SellerInfo {

                /**
                 * 销方名称 [180]
                 **/
                private String sellerName;

                /**
                 * 销方税号 [20]
                 **/
                private String sellerTaxNo;

                /**
                 * 销方地址 [180]
                 **/
                private String sellerAddress;

                /**
                 * 销方电话 [20]
                 **/
                private String sellerTel;

                /**
                 * 销方开户行 [80]
                 **/
                private String sellerBankName;

                /**
                 * 销方开户行账号 [40]
                 **/
                private String sellerBankAccount;
            }

            /**
             * 购方信息
             **/
            private BuyerInfo buyer;

            @Data
            public static class BuyerInfo {

                /**
                 * 购方名称 [180]
                 **/
                private String buyerName;

                /**
                 * 购方税号 [20]
                 **/
                private String buyerTaxNo;

                /**
                 * 购方地址 [180]
                 **/
                private String buyerAddress;

                /**
                 * 购方电话 [20]
                 **/
                private String buyerTel;

                /**
                 * 购方开户行 [80]
                 **/
                private String buyerBankName;

                /**
                 * 购方开户行账号 [40]
                 **/
                private String buyerBankAccount;

                /**
                 * 是否开票给自然人标识
                 * 默认为否
                 */
                private Boolean isNatureFlag;
            }

            /**
             * 发票金额信息
             **/
            private InvoiceAmountInfo invoiceAmount;

            @Data
            public static class InvoiceAmountInfo {

                /**
                 * 合计金额（18位，2位小数）
                 **/
                private BigDecimal amountWithoutTax;

                /**
                 * 价税合计（18位，2位小数）
                 **/
                private BigDecimal amountWithTax;

                /**
                 * 合计税额（18位，2位小数）
                 **/
                private BigDecimal taxAmount;
            }

            /**
             * 红字信息
             **/
            private RedLetterInfo redLetter;

            @Data
            public static class RedLetterInfo {

                /**
                 * 原发票号码(本期不包含) [20]
                 **/
                private String originalInvoiceNo;

                /**
                 * 原纸票发票代码
                 * 仅纸票红冲需要
                 */
                private String originalPaperInvoiceCode;

                /**
                 * 原纸票发票号码
                 * 仅纸票红冲需要
                 */
                private String originalPaperInvoiceNo;

                /**
                 * 红字确认单编号[32]
                 **/
                private String redLetterNumber;
            }

            /**
             * 备注 纸票长度230 电票长度200
             **/
            private String remark;

            /**
             * 价格方式(1-含税,0-不含税，默认: 不含税)
             * 本期仅含不含税开具
             */
            private String pricingMethod = "0";

            /**
             * 明细列表
             **/
            private List<Details> details;

            @Data
            public static class Details {

                /**
                 * pid
                 */
                private String pid;

                private Integer rowNum;

                /**
                 * 原蓝票明细行号
                 */
                private Integer originInvoiceRowNum;

                /**
                 * 明细金额信息
                 **/
                private DetailAmountInfo detailAmount;

                @Data
                public static class DetailAmountInfo {

                    /**
                     * 数量（16位，小数位不超过13位）（单位非空时非空）
                     **/
                    private BigDecimal quantity;

                    /**
                     * 不含税单价（16位，小数位不超过13位）（单位非空时非空）
                     **/
                    private BigDecimal unitPrice;

                    /**
                     * 不含税金额（18位，2位小数）
                     **/
                    private BigDecimal amountWithoutTax;

                    /**
                     * 税额（18位，2位小数）
                     **/
                    private BigDecimal taxAmount;

                    /**
                     * 含税金额（18位，2位小数）
                     **/
                    private BigDecimal amountWithTax;
                }

                /**
                 * 折扣金额信息
                 */
                private DiscountAmountInfo discountAmount;

                @Data
                public static class DiscountAmountInfo {

                    /**
                     * 小数点保留最多2位 不含税折扣额
                     */
                    private BigDecimal discountWithoutTax;

                    /**
                     * 小数点保留最多2位 折扣税额
                     */
                    private BigDecimal discountTax;

                    /**
                     * 小数点保留最多2位 含税折扣额
                     */
                    private BigDecimal discountWithTax;
                }

                /**
                 * 商品信息
                 **/
                private ItemInfo item;

                @Data
                public static class ItemInfo {

                    /**
                     * 商品名称（*简称*商品名称） [100]
                     **/
                    private String itemName;

                    /**
                     * 规格型号 [40]
                     **/
                    private String specifications;

                    /**
                     * 单位 [20]
                     **/
                    private String unit;
                }

                /**
                 * 税务信息
                 **/
                private TaxInfo tax;

                @Data
                public static class TaxInfo {

                    /**
                     * 税率
                     * （3%税率时传入0.03）
                     **/
                    private BigDecimal taxRate;

                    /**
                     * 税编 [19]
                     **/
                    private String goodsTaxNo;

                    /**
                     * 税收优惠政策类型代码（仅全电电票支持）
                     * （枚举值详见：
                     * https://xforceplus.yuque.com/dew9bm/yagacb/qwzueume97ouom15
                     * 二、全电优惠政策类型枚举）
                     **/
                    private String taxIncentivesType;

                    /**
                     * 全电即征即退补充枚举（仅全电电票支持）
                     * (当taxIncentivesType为11-18时需要传入)
                     * (枚举值详见:
                     * https://xforceplus.yuque.com/dew9bm/yagacb/qwzueume97ouom15
                     * 三、全电即征即退类型枚举)
                     */
                    private String vatRefundType;
                }
            }

            /**
             * 扩展字段数组
             */
            private List<List<Extra>> extra;

            @Data
            public static class Extra {
                private String name;
                private String value;
            }
        }
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class Response extends OpenApiBaseResponseDto {
        private Result result;

        @Data
        public static class Result {

            private String taskId;
        }
    }
}
