package com.xforceplus.taxware.contract.allelectric.message.enumeration;

import java.util.Arrays;

/**
 * 全电登录方式
 *
 * @author Bobo
 * @create 2022/7/5 10:54
 * @since 1.0.0
 */
public enum AeLoginTypeEnum {
    CLIENT("client", "客户端登录"),
    SERVER("server", "服务端登录");

    private String type;
    private String text;

    AeLoginTypeEnum(String type, String text) {
        this.type = type;
        this.text = text;
    }

    public static AeLoginTypeEnum from(String type) {
        return Arrays.stream(AeLoginTypeEnum.values())
                .filter(value -> value.type.equals(type))
                .findAny().orElse(null);
    }

    public String getType() {
        return type;
    }
}
