package com.xforceplus.taxware.contract.allelectric.message.enumeration;

import org.jetbrains.annotations.NotNull;

import java.util.Arrays;

/**
 * @author Thj
 * @createdAt: 2022/11/29 15:23
 * @Description: 全电特定业务枚举
 */
public enum InvoiceStyleTypeEnum {
    CPY("01", "成品油", "", false),
    TOMBARTHITE("02", "稀土", "", false),
    BUILDING_SERVICE("03", "建筑服务", "constructionServices", true),
    TRANSFER_SERVICE("04", "货物运输服务", "freightage", true),
    IMMOVABLES_SALES("05", "不动产销售", "realEstateSales", true),
    IMMOVABLES_MANAGE_SERVICE("06", "不动产经营租赁服务", "realLeasehold", true),
    VEHICLE_AND_VESSEL_TAX_COLLECTION("07", "代收车船税", "", true),
    TRAVELLER_TRANSPORT_SERIVCE("09", "旅客运输服务", "", true),
    IN_HOSPITAL_SERVICE("10", "医疗服务（住院）", "", true),
    OUTPATIENT_HOSPITAL_SERVICE("11", "医疗服务（门诊）", "", true),
    SELF_FARM_PRODUCE_SALES("12", "自产农产品销售", "", false),
    TRACTORS_AND_COMBINES("13", "拖拉机和联合收割机", "", true),
    VEHICLES("14", "机动车", "", true),
    SECOND_HAND_VEHICLES("15", "二手车", "", true),
    FARM_PRODUCE_PURCHASE("16", "农产品收购", "", false),
    GUANGFU_PURCHASE("17", "光伏收购", "", false),
    CIGARETTE("18", "卷烟", "", false),
    SPECIAL_INVOICE_FARM_PRODUCE("20", "专票农产品", "", false),
    RAILWAY_ELECTRIC_CUSTOMER_INVOICE(null, "铁路电子客票", "", true),
    AIR_TRANSPORT_ELECTRIC_CUSTOMER_INVOICE(null, "航空运输电子客票行程单", "", true),
    SPECIAL_SECOND_HAND_VEHICLES("21", "二手车*", "", true),
    ELECTRIC_CIGARETTE(null, "电子烟", "", false),
    NORMAL_CIGARETTE_INVOICE(null, "卷烟正常开具", "", false),
    OPPOSITE_CIGARETTE_INVOICE(null, "卷烟反向开具", "", false),
    ;

    private String code;
    private String name;
    private String ultramanBoCode;
    private Boolean isNeedExtra;

    InvoiceStyleTypeEnum(String code, String name, String ultramanBoCode, Boolean isNeedExtra) {
        this.code = code;
        this.name = name;
        this.ultramanBoCode = ultramanBoCode;
        this.isNeedExtra = isNeedExtra;
    }

    public String toCode() {
        return code;
    }

    public String toName() {
        return name;
    }

    public String toUltramanBoCode() {
        return ultramanBoCode;
    }

    public Boolean isNeedExtra() {
        return isNeedExtra;
    }

    public static InvoiceStyleTypeEnum fromCode(@NotNull String code) {

        return Arrays.stream(InvoiceStyleTypeEnum.values())
                .filter(invoiceStyleTypeEnum -> code.equals(invoiceStyleTypeEnum.toCode()))
                .findAny().orElse(null);
    }
}
