/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.contract.allelectric.message.enumeration;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum AeLoginModelEnum {
    TAX_APP(1, "tax", 3, "\u7a0e\u52a1APP"),
    PERSON_APP(2, "person", 5, "\u4e2a\u7a0eAPP"),
    ACCOUNT(4, "account", null, "\u8d26\u53f7\u5bc6\u7801");

    private Integer code;
    private String model;
    private Integer componentVersion;
    private String text;

    private AeLoginModelEnum(Integer code, String model, Integer componentVersion, String text) {
        this.code = code;
        this.model = model;
        this.componentVersion = componentVersion;
        this.text = text;
    }

    public static AeLoginModelEnum from(String model) {
        return Arrays.stream(AeLoginModelEnum.values()).filter(value -> value.model.equals(model)).findAny().orElse(null);
    }

    public static List<AeLoginModelEnum> fromCode(Integer code) {
        if (code == null || code == 0) {
            return Lists.newArrayList();
        }
        return Arrays.stream(AeLoginModelEnum.values()).filter(x -> (x.code & code) > 0).collect(Collectors.toList());
    }

    public static List<String> toModeList(List<AeLoginModelEnum> aeLoginModelEnumList) {
        if (aeLoginModelEnumList == null) {
            return Lists.newArrayList();
        }
        return aeLoginModelEnumList.stream().map(AeLoginModelEnum::getModel).collect(Collectors.toList());
    }

    public Integer getCode() {
        return this.code;
    }

    public String getModel() {
        return this.model;
    }

    public Integer getComponentVersion() {
        return this.componentVersion;
    }

    public String getText() {
        return this.text;
    }
}

