/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.contract.allelectric.message.enumeration;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public enum ServiceNameEnum {
    MAKE("make", 1, "\u5f00\u7968"),
    ASSISTANT("assistant", 2, "\u62bd\u53d6"),
    RNFN_APPLY("rnfnApply", 4, "\u7ea2\u5b57\u4fe1\u606f\u8868\u7533\u8bf7"),
    RED_LETTER_APPLY("redLetterApply", 8, "\u7ea2\u5b57\u786e\u8ba4\u5355\u7533\u8bf7"),
    RED_LETTER_DOWNLOAD("redLetterDownload", 16, "\u7ea2\u5b57\u786e\u8ba4\u5355\u540c\u6b65"),
    AUTHENTICATION("authentication", 32, "\u8ba4\u8bc1"),
    AUTHENTICATION_NCP("authenticationNcp", 64, "\u519c\u4ea7\u54c1"),
    AUTHENTICATION_JKS("authenticationJks", 128, "\u6d77\u5173\u7f34\u6b3e\u4e66"),
    VERIFICATION("verification", 256, "\u9a8c\u771f"),
    ENTRY("entry", 512, "\u53d1\u7968\u5165\u8d26"),
    COLLECTION("collection", 1024, "\u53d1\u7968\u5f52\u96c6"),
    BEMANEGED_TAXDISK("beManegedTaxDisk", 2048, "\u5355\u76d8\u6258\u7ba1"),
    BEMANEGED_SK("beManegedSk", 4096, "\u6838\u5fc3\u677f\u6258\u7ba1"),
    BEMANEGED_RZS("beManegedRzs", 8192, "\u8f6f\u8bc1\u4e66\u6258\u7ba1"),
    BEMANEGED_TRUMPRT("beManegedTrumprt", 16384, "\u865a\u62df\u53f7\u6258\u7ba1"),
    AUTHENTICATION_WSPZ("authenticationWspz", 32768, "\u5b8c\u7a0e\u51ed\u8bc1"),
    AUTHENTICATION_NCP_JJKC("authenticationNcpjjkc", 65536, "\u519c\u4ea7\u54c1\u52a0\u8ba1\u6263\u9664"),
    VERIFICATION_MEDICAL("verificationMedical", 131072, "\u9a8c\u771f\u533b\u7597\u7968\u636e");

    private final String name;
    private final int numCode;
    private final String desc;

    private ServiceNameEnum(String name, int numCode, String desc) {
        this.name = name;
        this.numCode = numCode;
        this.desc = desc;
    }

    public String toName() {
        return this.name;
    }

    public int toNumCode() {
        return this.numCode;
    }

    public String toDesc() {
        return this.desc;
    }

    public static ServiceNameEnum fromName(String name) {
        return Arrays.stream(ServiceNameEnum.values()).filter(x -> Objects.equals(x.name, name)).findAny().orElse(null);
    }

    public static List<ServiceNameEnum> fromNameList(List<String> codeList) {
        if (codeList == null) {
            return Lists.newArrayList();
        }
        return codeList.stream().map(x -> ServiceNameEnum.fromName(x)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<ServiceNameEnum> fromNumCode(Integer numCode) {
        if (numCode == null || numCode == 0) {
            return Lists.newArrayList();
        }
        return Arrays.stream(ServiceNameEnum.values()).filter(x -> (x.numCode & numCode) > 0).collect(Collectors.toList());
    }

    public static int to(List<ServiceNameEnum> enums) {
        int numCode = 0;
        if (enums == null) {
            return numCode;
        }
        for (ServiceNameEnum eEnum : enums) {
            numCode += eEnum.numCode;
        }
        return numCode;
    }

    public static List<String> toNameList(List<ServiceNameEnum> enums) {
        if (enums == null) {
            return Lists.newArrayList();
        }
        return enums.stream().map(ServiceNameEnum::toName).collect(Collectors.toList());
    }
}

