/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.contract.allelectric.message.enumeration;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public enum TaxpayerTypeEnum {
    NORMAL_TAX_PAYER("1", "NormalTaxPayer", "\u4e00\u822c\u7eb3\u7a0e\u4eba"),
    SMALL_TAX_PAYER("2", "SmallTaxPayer", "\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba"),
    RE_REGISTERED_SMALL_TAX_PAYER("3", "ReRegisteredSmallTaxPayer", "\u8f6c\u767b\u8bb0\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba"),
    TUTORIAL_PERIOD_NORMAL_TAXPAYER("4", "TutorialPeriodNormalTaxPayer", "\u8f85\u5bfc\u671f\u4e00\u822c\u7eb3\u7a0e\u4eba"),
    NATURAL_PERSON("5", "NaturalPerson", "\u81ea\u7136\u4eba");

    private final String code;
    private final String name;
    private final String text;

    private TaxpayerTypeEnum(String code, String name, String text) {
        this.code = code;
        this.name = name;
        this.text = text;
    }

    public static TaxpayerTypeEnum fromCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return Arrays.stream(TaxpayerTypeEnum.values()).filter(typeEnum -> code.equals(typeEnum.getCode())).findAny().orElse(null);
    }

    public static TaxpayerTypeEnum fromName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return Arrays.stream(TaxpayerTypeEnum.values()).filter(typeEnum -> name.equals(typeEnum.getName())).findAny().orElse(null);
    }

    public static TaxpayerTypeEnum fromText(String text) {
        return Arrays.stream(TaxpayerTypeEnum.values()).filter(typeEnum -> StringUtils.equals((CharSequence)typeEnum.getText(), (CharSequence)text)).findAny().orElse(null);
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getText() {
        return this.text;
    }
}

