package com.xforceplus.taxware.contract.allelectric.message;

import com.xforceplus.taxware.contract.allelectric.message.common.OpenApiBaseResponseDto;
import lombok.Data;

/**
 * @author Thj
 * @createdAt: 2024/4/17 11:29
 * @Description:
 */
@Data
public class AeInvoiceCancelResultMessage extends OpenApiBaseResponseDto {

    @Data
    public static class Properties {

        /**
         * 业务编号
         */
        private String businessNo;

        /**
         * 调用方系统
         */
        private String fromSystem;

        /**
         * 租户id
         */
        private String tenantId;
    }

    /**
     * 结果
     **/
    private Result result;

    @Data
    public static class Result {

        /**
         * 请求流水号
         **/
        private String taskId;

        /**
         * 纸票发票代码
         **/
        private String tenantId;

        private String allElectricInvoiceNo;

        /**
         * 发票号码
         */
        private String invoiceNo;

        /**
         * 纸票发票号码
         */
        private String invoiceCode;

        /**
         * 作废日期
         * yyyy-MM-dd
         */
        private String cancelDate;
    }
}
