package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 全电销方基础信息消息
 * <p>
 * https://api-mock.xforceplus.com/project/141/interface/api/41432
 *
 * @author Bobo
 * @create 2022/8/23 11:57
 * @since 1.0.0
 */
public class AeSellerBasicInfoMessage {

    @Data
    public static class Request {

        /**
         * 开票方式（ns：乐企 dppt：电票平台)
         */
        private String issueType = "dppt";

        /**
         * 税号
         **/
        private String taxNo;

        /**
         * 公司名称
         **/
        private String companyName;

        /**
         * 在线开票人
         **/
        private String issuer;

        /**
         * 总授信额度(18,2)
         */
        private BigDecimal creditLines;

        /**
         * 可用授信额度(18,2)
         */
        private BigDecimal balanceCreditLines;

        /**
         * 已下载未使用额度(18,2)
         */
        private BigDecimal unusedAmount;

        /**
         * 局端可用剩余额度(18,2)
         */
        private BigDecimal remainAmount;

        /**
         * 纳税人类型
         **/
        private String taxpayerType;

        /**
         * 纳税人信用等级
         * A\B\C\D\M
         **/
        private String taxpayerCreditRating;

        /**
         * 风险纳税人类型
         * 01：Ⅰ类（高风险）纳税人
         * 02：Ⅱ类（中风险）纳税人
         * 03：Ⅲ类（低风险）纳税人
         * 04：Ⅳ类（无风险）纳税人
         **/
        private String taxpayerRiskType;

        /**
         * 授信额度更新时间(格式:yyyy-MM-dd HH:mm:ss.SSS)
         **/
        private String creditLinesUpdateTime;

        /**
         * 销方银行信息列表
         */
        private List<SellerBank> sellerBankList;

        /**
         * 销方地址列表
         */
        private List<String> sellerAddressList;

        /**
         * 销方电话列表
         */
        private List<String> sellerTelephoneList;

    }

    @Data
    public static class Response {

        /**
         * 返回码（1为成功 其余为失败）
         */
        private String code = "1";

        /**
         * 返回信息
         */
        private String message = "成功";

        /**
         * 追踪码
         */
        private String traceId;

        /**
         * 结果
         **/
        private Result result;

    }

    @Data
    public static class Result {

        /**
         * 开票方式（ns：乐企 dppt：电票平台)
         */
        private String issueType = "dppt";

        /**
         * 税号
         **/
        private String taxNo;

        /**
         * 总授信额度(18,2)
         */
        private BigDecimal creditLines;

        /**
         * 可用授信额度(18,2)
         */
        private BigDecimal balanceCreditLines;

        /**
         * 已下载未使用额度(18,2)
         */
        private BigDecimal unusedAmount;

        /**
         * 局端可用剩余额度(18,2)
         */
        private BigDecimal remainAmount;

        /**
         * 纳税人类型
         **/
        private String taxpayerType;

        /**
         * 纳税人信用等级
         * A\B\C\D\M
         **/
        private String taxpayerCreditRating;

        /**
         * 风险纳税人类型
         * 01：Ⅰ类（高风险）纳税人
         * 02：Ⅱ类（中风险）纳税人
         * 03：Ⅲ类（低风险）纳税人
         * 04：Ⅳ类（无风险）纳税人
         **/
        private String taxpayerRiskType;

        /**
         * 用户身份（身份类别_号码，示例：201_3204xxxx）
         **/
        private String issuerIdentity;

        /**
         * 授信额度更新时间(格式:yyyy-MM-dd HH:mm:ss.SSS)
         **/
        private String creditLinesUpdateTime;

        /**
         * 销方银行信息列表
         */
        private List<SellerBank> sellerBankList;

        /**
         * 销方地址列表
         */
        private List<String> sellerAddressList;

        /**
         * 销方电话列表
         */
        private List<String> sellerTelephoneList;
    }

    @Data
    public static class SellerBank {

        /**
         * 销方开户行 [80]
         **/
        private String sellerBankName;

        /**
         * 销方开户行账号 [40]
         **/
        private String sellerBankAccount;

    }
}
