package com.xforceplus.taxware.contract.allelectric.message;

import com.xforceplus.taxware.architecture.g1.domain.contract.BaseRestfulParameterDTO;
import com.xforceplus.taxware.architecture.g1.domain.contract.BaseRestfulResponseDTO;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 企业可用税率查询接口
 */
public class GetEnterpriseAvailableTaxRateMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Parameter extends BaseRestfulParameterDTO {

        /**
         * 税号
         **/
        private String taxCode;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseRestfulResponseDTO {

        /**
         * 返回结果
         **/
        private Result result;

        @Data
        public static class Result {

            /**
             * 税率列表
             **/
            private List<TaxRate> taxRateList;

            @Data
            public static class TaxRate {
                /**
                 * 税率性质
                 **/
                private String taxRateType;

                /**
                 * 税率
                 **/
                private BigDecimal taxRate;

                /**
                 * 含税标志
                 **/
                private boolean withTaxFlag;
            }
        }
    }
}
