package com.xforceplus.taxware.contract.allelectric.message;

import com.xforceplus.taxware.architecture.g1.domain.contract.BaseRestfulParameterDTO;
import com.xforceplus.taxware.architecture.g1.domain.contract.BaseRestfulResponseDTO;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 身份认证查询接口
 */
public class GetIdentityAuthenticationMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Parameter extends BaseRestfulParameterDTO {

        /**
         * 税号
         **/
        private String taxCode;

        /**
         * 认证人姓名
         **/
        private String name;

        /**
         * 认证人证件类型
         * 201：居民身份证（默认）
         * 210：港澳居民来往内地通行证
         * 213：台湾居民来往大陆通行证
         * 227：中国护照
         * 233：外国人永久居留身份证（外国人永久居留证
         * 237：中华人民共和国港澳居民居住证
         * 238：中华人民共和国台湾居民居住证
         **/
        private String idNoType = "201";

        /**
         * 认证人证件号
         **/
        private String idNo;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseRestfulResponseDTO {

        /**
         * 结果
         **/
        private Result result;

        @Data
        public static class Result {

            /**
             * 认证结果
             * 0：暂无结果 1：认证通过 2：认证不通过
             **/
            private String authenticationResult;

            /**
             * 有效时长（格式：yyyy-MM-dd HH:mm:ss）
             **/
            private String effectiveDate;
        }
    }
}
