package com.xforceplus.taxware.contract.allelectric.message;

import com.xforceplus.taxware.architecture.g1.domain.contract.BaseRestfulParameterDTO;
import com.xforceplus.taxware.architecture.g1.domain.contract.BaseRestfulResponseDTO;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 身份认证二维码获取接口
 */
public class GetIdentityAuthenticationQrcodeMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Parameter extends BaseRestfulParameterDTO {

        /**
         * 税号
         **/
        private String taxCode;

        /**
         * 认证人姓名
         **/
        private String name;

        /**
         * 认证人证件类型
         * 201：居民身份证（默认）
         * 210：港澳居民来往内地通行证
         * 213：台湾居民来往大陆通行证
         * 227：中国护照
         * 233：外国人永久居留身份证（外国人永久居留证
         * 237：中华人民共和国港澳居民居住证
         * 238：中华人民共和国台湾居民居住证
         **/
        private String idNoType = "201";

        /**
         * 认证人证件号
         **/
        private String idNo;

        /**
         * 地区代码
         * 156: 中国（默认）
         * 344: 香港
         **/
        private String regionCode = "156";
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseRestfulResponseDTO {

        /**
         * 结果
         **/
        private Result result;

        @Data
        public static class Result {

            /**
             * 二维码
             **/
            private String qrCode;
        }
    }
}
