package com.xforceplus.taxware.contract.allelectric.message;

import com.xforceplus.taxware.contract.allelectric.message.common.OpenApiBaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 报废产品收购个人已开额度查询结果
 *
 * @author zhouwen
 * @date 2024-09-06
 */
public class GetNaturalPersonQuotaQueryResultMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends OpenApiBaseResponseDto {
        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 任务状态（true = 完成，false = 处理中）
             */
            private Boolean taskFlag;
            private SuccessResult successResult = new SuccessResult();

            @Data
            public static class SuccessResult {

                /**
                 * 自然人姓名
                 */
                private String name;

                /**
                 * 自然人证件类型
                 */
                private String idType;

                /**
                 * 自然人证件号码
                 */
                private String idCard;

                /**
                 * 已开票不含税金额
                 */
                private String amountWithoutTax;
            }
        }
    }
}