package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author Thj
 * @createdAt: 2023/6/20 11:15
 * @Description:
 */
@Data
public class GetRedInvoiceFromRedLetterResultMessage {

    @Data
    public static class Properties {

        /**
         * 业务编号
         */
        private String businessNo;

        /**
         * 调用方系统
         */
        private String fromSystem;

        /**
         * 租户id
         */
        private String tenantId;
    }

    /**
     * 错误码：成功：1，失败：其他编码
     **/
    private String code = "1";

    /**
     * 描述
     **/
    private String message;

    /**
     * 结果
     **/
    private Result result;

    @Data
    public static class Result {

        /**
         * 请求流水号
         **/
        private String taskId;

        /**
         * 租户id
         */
        private String tenantId;

        /**
         * 红字确认单编号
         **/
        private String redLetterNumber;

        /**
         * 红字确认单状态：
         * 01-无需确认
         * 02-销方录入待购方确认
         * 03-购方录入待销方确认
         * 04-购销双方已确认
         * 05-作废（销方录入购方否认）
         * 06-作废（购方录入销方否认）
         * 07-作废（超72小时未确认）
         * 08-作废（发起方已撤销）
         * 09-作废（确认后撤销）
         * 10-作废（异常凭证）
         */
        private String redLetterStatus;

        /**
         * 是否确认即开票，即经过无需确认或对方确认后，红票会不会自动被开出
         */
        private Boolean isMakeInvoiceAfterConfirm;

        /**
         * 开具状态：有2个枚举：
         * isInvoiced-已开具，
         * notInvoiced-未开具
         */
        private String makeInvoiceStatus;

        /**
         * 查询到的红票信息
         */
        private RedInvoice redInvoice;

        @Data
        public static class RedInvoice {

            /**
             * 数电发票号码
             */
            private String allElectricInvoiceNo;

            /**
             * 红冲（纸票、税控）发票号码
             */
            private String invoiceNo;

            /**
             * 红冲（纸票、税控）发票代码
             */
            private String invoiceCode;

            /**
             * 发票类型
             * qc:全电电普
             * qs:全电电专
             * cz: 全电纸普
             * sz: 全电纸专
             **/
            private String invoiceType;

            /**
             * 开票日期时间(yyyyMMddHHmmss)
             */
            private String dateIssued;

            /**
             * 国税交付地址
             */
            private String qrCodeUrl;

            /**
             * 备注
             */
            private String remark;

            /**
             * 特定要素类型代码
             */
            private String invoiceStyleType;

            /**
             * 原蓝字发票对象
             */
            private OriginInvoice originInvoice;

            @Data
            public static class OriginInvoice {

                /**
                 * 原蓝字发票数电发票号码
                 */
                private String originalAllElectricInvoiceNo;

                /**
                 * 原蓝字发票发票号码
                 */
                private String originalInvoiceNo;

                /**
                 * 原蓝字发票发票代码
                 */
                private String originalInvoiceCode;
            }

            /**
             * 销方信息
             */
            private SellerInfo seller;

            @Data
            public static class SellerInfo {

                /**
                 * 销方名称 [180]
                 **/
                private String sellerName;

                /**
                 * 销方税号 [20]
                 **/
                private String sellerTaxNo;

                /**
                 * 销方地址 [180]
                 **/
                private String sellerAddress;

                /**
                 * 销方电话 [20]
                 **/
                private String sellerTel;

                /**
                 * 销方开户行 [80]
                 **/
                private String sellerBankName;

                /**
                 * 销方开户行账号 [40]
                 **/
                private String sellerBankAccount;
            }

            /**
             * 购方信息
             **/
            private BuyerInfo buyer;

            @Data
            public static class BuyerInfo {

                /**
                 * 购方名称 [180]
                 **/
                private String buyerName;

                /**
                 * 购方税号 [20]
                 **/
                private String buyerTaxNo;

                /**
                 * 购方地址 [180]
                 **/
                private String buyerAddress;

                /**
                 * 购方电话 [20]
                 **/
                private String buyerTel;

                /**
                 * 购方开户行 [80]
                 **/
                private String buyerBankName;

                /**
                 * 购方开户行账号 [40]
                 **/
                private String buyerBankAccount;

                /**
                 * 是否开票给自然人标识
                 * 默认为否
                 */
                private Boolean isNatureFlag;
            }

            /**
             * 发票金额信息
             **/
            private InvoiceAmountInfo invoiceAmount;

            @Data
            public static class InvoiceAmountInfo {

                /**
                 * 合计金额（18位，2位小数）
                 **/
                private BigDecimal amountWithoutTax;

                /**
                 * 价税合计（18位，2位小数）
                 **/
                private BigDecimal amountWithTax;

                /**
                 * 合计税额（18位，2位小数）
                 **/
                private BigDecimal taxAmount;
            }

            /**
             * 操作人信息
             */
            private OperatorInfo operator;

            @Data
            public static class OperatorInfo {

                /**
                 * 开票人
                 */
                private String issuer;

                /**
                 * 收款人
                 */
                private String payee;

                /**
                 * 复核人
                 */
                private String reviewer;
            }

            /**
             * 特定要素扩展字段
             */
            private List<Map<String, Object>> extra;

            /**
             * 明细列表
             **/
            private List<Details> details;

            @Data
            public static class Details {

                private Integer rowNum;

                /**
                 * 明细折扣类型（0:普通明细;1:折扣明细;2:被折扣明细）
                 */
                private String discountType;

                /**
                 * 明细金额信息
                 **/
                private DetailAmountInfo detailAmount;

                @Data
                public static class DetailAmountInfo {

                    /**
                     * 数量（16位）（单位非空时非空）
                     **/
                    private BigDecimal quantity;

                    /**
                     * 不含税单价（21位）（单位非空时非空）
                     **/
                    private BigDecimal unitPrice;

                    /**
                     * 不含税金额（18位，2位小数）
                     **/
                    private BigDecimal amountWithoutTax;

                    /**
                     * 税额（18位，2位小数）
                     **/
                    private BigDecimal taxAmount;
                }

                /**
                 * 商品信息
                 **/
                private ItemInfo item;

                @Data
                public static class ItemInfo {

                    /**
                     * 商品名称 [100]
                     **/
                    private String itemName;

                    /**
                     * 规格型号 [40]
                     **/
                    private String specifications;

                    /**
                     * 单位 [20]
                     **/
                    private String unit;
                }

                /**
                 * 税务信息
                 **/
                private TaxInfo tax;

                @Data
                public static class TaxInfo {

                    /**
                     * 税率
                     **/
                    private BigDecimal taxRate;

                    /**
                     * 税编 [19]
                     **/
                    private String goodsTaxNo;

                    /**
                     * 税收优惠政策类型代码（枚举值详见：
                     * https://xforceplus.yuque.com/dew9bm/yagacb/qwzueume97ouom15
                     * 二、数电优惠政策类型枚举）
                     **/
                    private String taxIncentivesType;

                    /**
                     * 数电即征即退补充枚举 (当taxIncentivesType为11-18时需要传入)
                     * (枚举值详见:
                     * https://xforceplus.yuque.com/dew9bm/yagacb/qwzueume97ouom15
                     * 三、数电即征即退类型枚举)
                     */
                    private String vatRefundType;
                }
            }
        }
    }
}
