package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

/**
 * 新增、修改全电发票开票人
 * <p>
 * https://api-mock.xforceplus.com/project/141/interface/api/41236
 *
 * @author Bobo
 * @create 2023/7/31 15:58
 * @since 1.0.0
 */
public class PostCreateUpdateIssuerMessage {

    @Data
    public static class Request {

        /**
         * 税号
         **/
        private String taxNo;

        /**
         * 开票人
         **/
        private String issuer;

        /**
         * 开票方式 ns：乐企 dppt：电票平台（客户端）
         **/
        private String issueType;

        /**
         * 账号
         **/
        private String account;

        /**
         * 密码
         **/
        private String password;

        /**
         * 操作人
         **/
        private String operator;

        /**
         * 开票人状态
         **/
        private String status = "enabled";
    }

    @Data
    public static class Response {

        /**
         * 返回码（1为成功 其余为失败）
         */
        private String code = "1";

        /**
         * 返回信息
         */
        private String message = "成功";

        /**
         * 追踪码
         */
        private String traceId;

        /**
         * 结果
         **/
        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 开票人唯一码
             **/
            private String unionId;

        }
    }
}
