package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

import java.util.List;

/**
 * 红字确认单版式文件生成接口
 * <p>
 * 契约地址：<a href="https://api-mock.xforceplus.com/project/141/interface/api/44356">...</a>
 *
 * @author Bobo
 * @create 2024/4/25 16:43
 * @since 1.0.0
 */
public class RedLetterPdfMessage {

    @Data
    public static class Request {

        /**
         * 填开日期(yyyyMMdd)[必填]
         */
        private String redDate;

        /**
         * 红字确认单编号[必填]
         */
        private String redLetterNumber;

        /**
         * 合计不含税金额[必填]
         */
        private String totalAmountWithoutTax;

        /**
         * 合计税额[必填]
         */
        private String totalTaxAmount;

        /**
         * 蓝字发票代码
         */
        private String originalInvoiceCode;

        /**
         * 蓝字发票号码
         */
        private String originalInvoiceNo;

        /**
         * 控制项[必填]
         */
        private RedControl control;

        @Data
        public static class RedControl {

            /**
             * 申请方身份(01 - 销方, 02 - 购方) [2][必填]
             **/
            private String applyIdentity;

            /**
             * 申请红冲原因[必填]
             * making_error 开票有误
             * taxable_service_end应税服务中止
             * sales_allowance 销售折让
             * sales_return 销货退回
             */
            private String applyReason;

            /**
             * 对应蓝字发票抵扣增值税销项税额情况：1.已抵扣 2.未抵扣
             **/
            private String originalInvoiceDeductionStatus;

            /**
             * 是否涉及数量：1:涉及销售数量2:仅涉及销售金额
             **/
            private String involveQuantity;
        }

        /**
         * 销方信息
         **/
        private SellerInfo seller;

        @Data
        public static class SellerInfo {

            /**
             * 销方名称 [180]
             **/
            private String sellerName;

            /**
             * 销方税号 [20]
             **/
            private String sellerTaxNo;
        }

        /**
         * 购方信息
         **/
        private BuyerInfo buyer;

        @Data
        public static class BuyerInfo {

            /**
             * 购方名称 [180]
             **/
            private String buyerName;

            /**
             * 购方税号 [20]
             **/
            private String buyerTaxNo;
        }

        /**
         * 明细列表
         **/
        private List<Details> details;

        @Data
        public static class Details {

            /**
             * 商品名称[必填]
             **/
            private String itemName;

            /**
             * 数量
             **/
            private String quantity;

            /**
             * 单价
             **/
            private String unitPrice;

            /**
             * 不含税金额
             **/
            private String amountWithoutTax;

            /**
             * 税率(示例，16%传0.16）[必填]
             **/
            private String taxRate;

            /**
             * 税额
             **/
            private String taxAmount;

        }
    }

    @Data
    public static class Response {

        /**
         * 返回码（1为成功 其余为失败）
         */
        private String code = "1";

        /**
         * 返回信息
         */
        private String message = "成功";

        /**
         * 追踪码
         */
        private String traceId;

        /**
         * 结果
         **/
        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * pdf文件地址
             **/
            private String pdfUrl;
        }
    }
}
