package com.xforceplus.taxware.contract.allelectric.message.enumeration;

import java.util.Arrays;

/**
 * @author Thj
 * @createdAt: 2023/9/15 17:54
 * @Description:
 */
public enum BuyerIdentityTypeEnum {
    SFZ("01", "居民身份证"),
    PASSPORT("02", "外国护照"),
    HKTRANSIT("03", "港澳居民来往内地通行证"),
    TWTRANSIT("04", "台湾居民来往大陆通行证"),
    FOREIGNERSTAY("05", "外国人居留证"),
    HKSFZ("06", "香港永久性居民身份证"),
    TWSFZ("07", "台湾身份证"),
    AOMENSFZ("08", "澳门特别行政区永久性居民身份证"),
    FOREIGNERSFZ("09", "外国人永久居留身份证（外国人永久居留证）"),
    TAXIDENTITY("10", "税务登记证"),
    OTHER("11", "其他个人证件")
    ;

    private String code;
    private String name;

    BuyerIdentityTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static BuyerIdentityTypeEnum fromCode(String code) {
        return Arrays.stream(BuyerIdentityTypeEnum.values())
                .filter(value -> value.code.equals(code))
                .findAny().orElse(null);
    }

    public String toCode() {
        return code;
    }

    public String toName() {
        return name;
    }
}
