package com.xforceplus.taxware.contract.allelectric.message.enumeration;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * @author Bobo
 * @create 2024/8/21 18:09
 * @since 1.0.0
 */
public enum SellerIdentityTypeEnum {
    SFZ("201", "居民身份证"),
    PASSPORT("208", "外国护照"),
    HKTRANSIT("210", "港澳居民来往内地通行证"),
    TWTRANSIT("213", "台湾居民来往大陆通行证"),
    FOREIGNERSTAY("215", "外国人居留证"),
    HKSFZ("219", "香港永久性居民身份证"),
    TWSFZ("220", "台湾身份证"),
    AOMENSFZ("221", "澳门特别行政区永久性居民身份证"),
    FOREIGNERSFZ("233", "外国人永久居留身份证（外国人永久居留证）"),
    TAXIDENTITY("103", "税务登记证"),
    OTHER("299", "其他个人证件");

    private final String code;
    private final String name;

    SellerIdentityTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static SellerIdentityTypeEnum fromCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        return Arrays.stream(SellerIdentityTypeEnum.values())
                .filter(value -> value.code.equals(code))
                .findAny().orElse(null);
    }

    public String toCode() {
        return code;
    }

    public String toName() {
        return name;
    }

}
