/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.contract.allelectric.message.enumeration;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public enum RelatedTypeEnum {
    LEGAL_REPRESENTATIVE("01", "\u6cd5\u5b9a\u4ee3\u8868\u4eba"),
    FINANCE_PERSON("02", "\u8d22\u52a1\u8d1f\u8d23\u4eba"),
    TAX_OFFICER("03", "\u529e\u7a0e\u5458"),
    ADMINISTRATORS("05", "\u7ba1\u7406\u5458"),
    TICKET_COLLECTOR("07", "\u9886\u7968\u5458"),
    SOCIAL_INSURANCE("08", "\u793e\u4fdd\u7ecf\u529e\u4eba"),
    ISSUER("09", "\u5f00\u7968\u5458"),
    SALESPERSON("10", "\u9500\u552e\u4eba\u5458");

    private final String code;
    private final String name;

    private RelatedTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static RelatedTypeEnum fromCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return Arrays.stream(RelatedTypeEnum.values()).filter(value -> value.code.equals(code)).findAny().orElse(null);
    }

    public static RelatedTypeEnum fromName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return Arrays.stream(RelatedTypeEnum.values()).filter(value -> value.name.equals(name)).findAny().orElse(null);
    }

    public static List<RelatedTypeEnum> fromCodes(String codes) {
        if (StringUtils.isBlank((CharSequence)codes)) {
            return Lists.newArrayList();
        }
        String[] codesArray = codes.split(",");
        return Arrays.stream(codesArray).map(RelatedTypeEnum::fromCode).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static String toCodes(List<RelatedTypeEnum> relatedTypeEnumList) {
        if (relatedTypeEnumList == null || relatedTypeEnumList.isEmpty()) {
            return null;
        }
        return relatedTypeEnumList.stream().map(RelatedTypeEnum::getCode).collect(Collectors.joining(","));
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }
}

