package com.xforceplus.taxware.contract.allelectric.message;

import com.xforceplus.taxware.contract.allelectric.message.common.OpenApiBaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author Thj
 * @createdAt: 2024/4/16 17:08
 * @Description: 数电发票作废契约
 */
public class AeInvoiceCancelMessage {

    @Data
    public static class Request {

        /**
         * 流水号
         */
        private String taskId;

        /**
         * 税号
         */
        private String taxNo;

        /**
         * 开票人
         */
        private String issuer;

        /**
         * 作废原因:
         * invoiceError:开票有误
         * taxServiceEnd:服务中止
         * salesAllowance:销售折让
         * salesReturn:销货退回
         * other:其他
         */
        private String cancelReason;

        /**
         * 作废详细原因（当作废原因为other时 此项必填）
         */
        private String cancelReasonDetail;

        /**
         * 作废发票信息
         */
        private CancelInvoiceInfo cancelInvoiceInfo;

        @Data
        public static class CancelInvoiceInfo {

            /**
             * 全电发票号码
             */
            private String allElectricInvoiceNo;

            /**
             * 发票类型：
             * sz：数电纸专票
             * cz：数电纸普票
             */
            private String invoiceType;

            /**
             * 发票代码（数电纸票发票代码）
             */
            private String invoiceCode;

            /**
             * 发票号码（数电纸票发票号码）
             */
            private String invoiceNo;

            /**
             * 开票日期
             * yyyy-MM-dd HH:mm:ss
             */
            private String invoiceDate;
        }
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class Response extends OpenApiBaseResponseDto {
        private Result result;

        @Data
        public static class Result {

            private String taskId;
        }
    }
}
