package com.xforceplus.taxware.contract.allelectric.message;

import com.xforceplus.taxware.architecture.g1.domain.contract.BaseRestfulParameterDTO;
import com.xforceplus.taxware.architecture.g1.domain.contract.BaseRestfulResponseDTO;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 全电发票数据查询接口
 * <p>
 * https://api-mock.xforceplus.com/project/136/interface/api/39000
 */
public class GetInvoiceMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Parameter extends BaseRestfulParameterDTO {

        /**
         * 预制发票id
         **/
        private String pid;

        /**
         * 发票号码
         **/
        private String invoiceNo;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseRestfulResponseDTO {

        /**
         * 结果
         **/
        private Result result;

        @Data
        public static class Result {

            /**
             * 预制发票id
             **/
            private String pid;

            /**
             * 发票号码 [20]
             **/
            private String invoiceNo;

            /**
             * 发票日期 [14]
             **/
            private String invoiceDate;

            /**
             * 发票类型
             * qc:全电普票
             * qs:全电专票
             **/
            private String invoiceType;

            /**
             * 版本 [10]
             * （固定值，电子发票的规范版本。试点阶段版本为0.1，正式推行后版本为1.0）
             **/
            private String version;

            /**
             * 特殊票种标签(待确认)
             * 00：非收购
             * 01：农产品收购
             * 02：光伏收购
             * 03：二手车收购
             **/
            private String specialInvoiceTag = "00";

            /**
             * 结算方式(待确认)
             * 现金,银行转账,票据,支付,微信,银联,预付卡,其他结算方式
             **/
            private String settlementMode;

            /**
             * 纳税人义务发生时间(待确认) [14]
             **/
            private String taxLiabilityTime;

            /**
             * 合同编号(待确认) [20]
             **/
            private String contractNo;

            /**
             * 销方信息(待确认)
             **/
            private SellerInfo seller;

            @Data
            public static class SellerInfo {

                /**
                 * 销方名称 [180]
                 **/
                private String sellerName;

                /**
                 * 销方税号 [20]
                 **/
                private String sellerTaxCode;

                /**
                 * 销方地址 [180]
                 **/
                private String sellerAddress;

                /**
                 * 销方电话 [20]
                 **/
                private String sellerTelNo;

                /**
                 * 销方开户行 [80]
                 **/
                private String sellerBank;

                /**
                 * 销方开户行账号 [40]
                 **/
                private String sellerBankAccount;

                /**
                 * 收款银行名称(待确认) [80]
                 **/
                private String payeeBank;

                /**
                 * 收款银行账号(待确认) [40]
                 **/
                private String payeeBankAccount;
            }

            /**
             * 购方信息
             **/
            private PurchaseInfo purchaser;

            @Data
            public static class PurchaseInfo {

                /**
                 * 购方名称 [180]
                 **/
                private String purchaserName;

                /**
                 * 购方税号 [20]
                 **/
                private String purchaserTaxCode;

                /**
                 * 购方地址 [180]
                 **/
                private String purchaserAddress;

                /**
                 * 购方电话 [20]
                 **/
                private String purchaserTelNo;

                /**
                 * 购方开户行 [80]
                 **/
                private String purchaserBank;

                /**
                 * 购方开户行账号 [40]
                 **/
                private String purchaserBankAccount;
            }

            /**
             * 操作人信息
             **/
            private OperatorInfo operator;

            @Data
            public static class OperatorInfo {

                /**
                 * 购方经办人 [16]
                 **/
                private String purchaserName;

                /**
                 * 购方经办人身份证号 [20]
                 **/
                private String purchaserIdentityNo;

                /**
                 * 购方经办人电话号码 [20]
                 **/
                private String purchaserTelNo;

                /**
                 * 开票人
                 **/
                private String drawerName;

                /**
                 * 开票人证件号码
                 **/
                private String drawerIdentityNo;

                /**
                 * 开票人证件类型
                 **/
                private String drawerIdentityType;
            }

            /**
             * 发票金额信息
             **/
            private InvoiceAmountInfo invoiceAmountInfo;

            @Data
            public static class InvoiceAmountInfo {

                /**
                 * 合计金额（18位，2位小数）
                 **/
                private BigDecimal amountWithoutTax;

                /**
                 * 价税合计（18位，2位小数）
                 **/
                private BigDecimal amountWithTax;

                /**
                 * 合计税额（18位，2位小数）
                 **/
                private BigDecimal taxAmount;
            }

            /**
             * 红字信息
             **/
            private RedInfo redInfo;

            @Data
            public static class RedInfo {

                /**
                 * 原发票号码 [20]
                 **/
                private String originalInvoiceNo;

                /**
                 * 红字确认单编号(待确认) [32]
                 **/
                private String redNotificationNo;

                /**
                 * 红字确认单UUID [32]
                 **/
                private String redNotificationUUid;
            }

            /**
             * 备注 [230]
             **/
            private String remark;

            /**
             * 明细列表
             **/
            private List<Details> detailList;

            @Data
            public static class Details {

                /**
                 * 明细折扣类型（0:普通明细;1:折扣明细;2:被折扣明细）
                 **/
                private String discountType;

                /**
                 * 明细金额信息
                 **/
                private DetailAmountInfo detailAmountInfo;

                @Data
                public static class DetailAmountInfo {

                    /**
                     * 数量（16位）（单位非空时非空）
                     **/
                    private BigDecimal quantity;

                    /**
                     * 不含税单价（21位）（单位非空时非空）
                     **/
                    private BigDecimal unitPrice;

                    /**
                     * 不含税金额（18位，2位小数）
                     **/
                    private BigDecimal amountWithoutTax;

                    /**
                     * 税额（18位，2位小数）
                     **/
                    private BigDecimal taxAmount;

                    /**
                     * 含税金额（18位，2位小数）
                     **/
                    private BigDecimal amountWithTax;

                    /**
                     * 扣除额（18位，2位小数）
                     **/
                    private BigDecimal taxDeduction;
                }

                /**
                 * 折扣金额信息
                 **/
                private DiscountAmountInfo discountAmountInfo;

                @Data
                public static class DiscountAmountInfo {

                    /**
                     * 折扣税额（小数点保留最多2位）
                     **/
                    private BigDecimal discountTax;

                    /**
                     * 不含税折扣额（小数点保留最多2位）
                     **/
                    private BigDecimal discountWithoutTax;
                }

                /**
                 * 商品信息
                 **/
                private ProdectionInfo productionInfo;

                @Data
                public static class ProdectionInfo {

                    /**
                     * 商品名称 [92]
                     **/
                    private String productionName;

                    /**
                     * 规格型号 [40]
                     **/
                    private String specification;

                    /**
                     * 单位 [22]
                     **/
                    private String unitName;
                }

                /**
                 * 税务信息
                 **/
                private TaxInfo taxInfo;

                @Data
                public static class TaxInfo {

                    /**
                     * 税率
                     **/
                    private BigDecimal taxRate;

                    /**
                     * 税编 [20]
                     **/
                    private String taxClassCode;

                    /**
                     * 优惠政策标识 [2]
                     * 01 简易征收
                     * 02 即征即退
                     * 03 稀土产品
                     * 04 免税
                     * 05 不征税
                     * 06 先征后退
                     **/
                    private String taxPolicyTag;
                }
            }
        }
    }
}
