package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 通过电票平台查询剩余可红冲信息
 * <a href="https://api-mock.xforceplus.com/project/136/interface/api/44484">...</a>
 *
 * @author Bobo
 * @create 2024/11/29 15:01
 * @since 1.0.0
 */
public class PostQueryDpptRedLetterMessage {

    @Data
    public static class Request {

        /**
         * 购方税号
         **/
        @Deprecated
        private String buyerTaxNo;

        /**
         * 根据查询方身份来确定传购销方税号，销方身份传销方税号，购方身份传购方税号
         **/
        private String taxNo;

        /**
         * 查询方身份(01 - 销方, 02 - 购方)
         **/
        private String applyIdentity;

        /**
         * 原蓝字发票数电发票号码
         */
        private String allElectricInvoiceNo;

        /**
         * 发票号码
         */
        private String invoiceNo;

        /**
         * 发票代码
         */
        private String invoiceCode;

        /**
         * 原蓝字发票开票日期[yyyy-MM-dd]
         */
        private String invoiceDate;
    }

    @Data
    public static class Response {

        /**
         * 返回码（1为成功 其余为失败）
         */
        private String code = "1";

        /**
         * 返回信息
         */
        private String message = "成功";

        /**
         * 结果
         **/
        private Result result = new Result();

        @Data
        public static class Result {

            private String sellerTaxNo;
            private String sellerName;
            private String buyerTaxNo;
            private String buyerName;
            /**
             * 原蓝字发票开票日期[yyyy-MM-dd HH:mm:ss]
             */
            private String invoiceDateTime;
            private List<Detail> details;
        }

        @Data
        public static class Detail {

            private Integer originInvoiceRowNum;
            private String goodsTaxNo;
            private String itemName;
            private String specifications;
            private String unit;
            private String unitPrice;
            private String quantity;
            private BigDecimal taxAmount;
            private BigDecimal amountWithoutTax;
            private BigDecimal taxRate;
        }
    }

}
