package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

/**
 * 查询实人认证状态
 * <p>
 * https://api-mock.xforceplus.com/project/141/interface/api/44222
 */
public class RealMeAuthStatusMessage {

    @Data
    public static class Request {

        /**
         * 租户ID-加密
         **/
        private String tenantId;

        /**
         * 税号
         **/
        private String taxNo;

        /**
         * 开票人
         **/
        private String issuer;

        /**
         * 是否需要实人认证标识
         **/
        private boolean needRealMeAuthFlag;

        /**
         * 实人认证时间(格式:yyyy-MM-dd HH:mm:ss.SSS)
         **/
        private String realMeAuthTime;

    }


    @Data
    public static class Response {

        /**
         * 返回码（1为成功 其余为失败）
         */
        private String code = "1";

        /**
         * 返回信息
         */
        private String message = "成功";

        /**
         * 追踪码
         */
        private String traceId;

        /**
         * 结果
         **/
        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 实人认证标识 true：需要实人认证 false：不需要实人认证
             **/
            private boolean needRealMeAuthFlag;

        }
    }
}
