package com.xforceplus.taxware.contract.allelectric.message.enumeration;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * @author lv
 * @create 2025/1/17 18:09
 * @since 1.0.0
 */
public enum IdentityTypeEnum {
    SFZ("201", "居民身份证"),
    WGHZ("208", "外国护照"),
    GAJMLWNDTXZ("210", "港澳居民来往内地通行证"),
    TWJMLWDLTXZ("213", "台湾居民来往大陆通行证"),
    ZGHZ("227", "中国护照"),
    WGYJJLSFZ("233", "外国人永久居留身份证（外国人永久居留证）"),
    ZHRMGHGGAJMJZZ("237", "中华人民共和国港澳居民居住证"),
    ZHRMGHGTWRMJMJZZ("238", "中华人民共和国台湾居民居住证"),
    QT("299", "其他个人证件");

    private final String code;
    private final String name;

    IdentityTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static IdentityTypeEnum fromCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        return Arrays.stream(IdentityTypeEnum.values())
                .filter(value -> value.code.equals(code))
                .findAny().orElse(null);
    }

    public String toCode() {
        return code;
    }

    public String toName() {
        return name;
    }

}
