package com.xforceplus.taxware.contract.allelectric.message;

import com.google.common.collect.Lists;
import com.xforceplus.taxware.contract.allelectric.message.common.OpenApiBaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author Thj
 * @createdAt: 2022/10/9 14:19
 * @Description: 全电纸票打印接口(异步批量)_快捷版契约
 * https://api-mock.xforceplus.com/project/136/interface/api/42598
 */
public class AeBatchInvoicePrintMessage {

    @Data
    public static class Request {
        private String taskId;

        /**
         * printInvoice-发票打印 printSalesList - 打印销货清单
         */
        private String mode;
        private List<AeInvoiceSimplePrint> printList = Lists.newArrayList();

        @Data
        public static class AeInvoiceSimplePrint {
            private String paperInvoiceCode;
            private String paperInvoiceNo;

            /**
             * 全电发票号码
             */
            private String invoiceNo;
        }
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class Response extends OpenApiBaseResponseDto {
        private Result result = new Result();

        @Data
        public static class Result {
            private String taskId;
        }
    }
}
