package com.xforceplus.taxware.contract.allelectric.message;

import com.xforceplus.taxware.architecture.g1.domain.contract.BaseRestfulParameterDTO;
import com.xforceplus.taxware.architecture.g1.domain.contract.BaseRestfulResponseDTO;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 企业基本信息查询接口
 */
public class GetEnterpriseBasicInformationMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Parameter extends BaseRestfulParameterDTO {

        /**
         * 税号
         **/
        private String taxCode;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseRestfulResponseDTO {

        /**
         * 查询结果
         **/
        private Result result;

        @Data
        public static class Result {

            /**
             * 企业信息列表
             **/
            private List<EnterpriseInfo> enterpriseInfoList;

            @Data
            public static class EnterpriseInfo {

                /**
                 * 纳税人识别号
                 **/
                private String taxCode;

                /**
                 * 纳税人名称
                 **/
                private String comapnyName;

                /**
                 * 地址(生产经营地址)
                 **/
                private String address;

                /**
                 * 银行账号(基本存款账号)
                 **/
                private String bankAccount;

                /**
                 * 联系电话
                 **/
                private String phoneNumber;

                /**
                 * 登记序号
                 **/
                private String registerNo;

                /**
                 * 纳税人类型
                 **/
                private String taxpayerType;

                /**
                 * 纳税人信用等级
                 **/
                private String taxpayerCreditLevel;

                /**
                 * 纳税人风险等级
                 **/
                private String taxpayerRiskLevel;

                /**
                 * 纳税人行业性质
                 **/
                private String taxpayerIndustryNature;

                /**
                 * 发票票种列表
                 **/
                private List<InvoiceTypeInfo> invoiceTypeList;

                @Data
                public static class InvoiceTypeInfo {

                    /**
                     * 发票票种
                     **/
                    private String invoiceType;

                    /**
                     * 是否纸质发票
                     **/
                    private boolean paperInvoiceFlag;
                }
            }
        }
    }
}
