package com.xforceplus.taxware.contract.allelectric.message;

import com.google.common.collect.Lists;
import lombok.Data;

import java.util.List;

/**
 * 全电发票开票人列表查询
 * <p>
 * 契约地址：<a href="https://api-mock.xforceplus.com/project/141/interface/api/41214">...</a>
 */
public class GetIssuerListMessage {

    @Data
    public static class Request {

        /**
         * 租户ID-加密
         **/
        private String tenantId;

        /**
         * 税号
         **/
        private String taxNo;

        /**
         * 开票人
         **/
        private List<String> issuers;

        /**
         * 开票人类型
         **/
        private String issueType;

        /**
         * 状态
         **/
        private String status = "enabled";

    }

    @Data
    public static class Response {

        /**
         * 返回码（1为成功 其余为失败）
         */
        private String code = "1";

        /**
         * 返回信息
         */
        private String message = "成功";

        /**
         * 追踪码
         */
        private String traceId;

        /**
         * 结果
         **/
        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 税号
             **/
            private String taxNo;

            /**
             * 开票方式列表 ns：乐企 dppt：电票平台（客户端）
             */
            private List<String> issueTypeList;

            /**
             * 登录方式 client：客户端登录 server：服务端登录
             **/
            private String loginType;

            /**
             * 最大轮询次数，服务端登录时返回
             */
            private Integer maxPolling;

            /**
             * 轮询间隔（单位毫秒），服务端登录时返回
             */
            private Integer pollingInterval;

            /**
             * 乐企支持特定要素类型代码
             */
            private List<String> nsInvoiceStyleTypeList;

            /**
             * 开票人列表
             */
            private List<Issuer> issuers = Lists.newArrayList();

        }

        @Data
        public static class Issuer {

            /**
             * 开票人
             **/
            private String issuer;

            /**
             * 开票方式 ns：乐企 dppt：电票平台
             */
            private String issueType;

            /**
             * 在线标志,true:在线 false:不在线
             **/
            private boolean onlineFlag;

            /**
             * 实人认证标识 true：需要实人认证 false：不需要实人认证
             **/
            private boolean needRealMeAuthFlag;

            /**
             * 开票人状态
             **/
            private String status;

            /**
             * 上次登录时间(格式:yyyy-MM-dd HH:mm:ss.SSS)
             **/
            private String lastLoginTime;

            /**
             * 上次实人认证时间(格式:yyyy-MM-dd HH:mm:ss.SSS)
             **/
            private String lastRealMeAuthTime;

            /**
             * 一人管多税号标识
             **/
            private boolean manageMultiTaxNoFlag;

            /**
             * 支持在线税号切换标识
             **/
            private boolean ableSwitchFlag;

        }
    }
}
