package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

/**
 * 全电发票开具资质查询
 * <p>
 * 契约地址：https://api-mock.xforceplus.com/project/141/interface/api/41208
 */
public class GetQualificationMessage {

    @Data
    public static class Request {

        /**
         * 租户ID-加密
         **/
        private String tenantId;

        /**
         * 税号
         **/
        private String taxNo;

    }

    @Data
    public static class Response {

        /**
         * 返回码（1为成功 其余为失败）
         */
        private String code = "1";

        /**
         * 返回信息
         */
        private String message = "成功";

        /**
         * 追踪码
         */
        private String traceId;

        /**
         * 结果
         **/
        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 销方税号
             **/
            private String sellerTaxNo;

            /**
             * 全电资质标识,true:有 false:没有
             **/
            private boolean allElectricFlag;

        }
    }
}
