package com.xforceplus.taxware.contract.allelectric.message;

import com.xforceplus.taxware.contract.allelectric.message.common.OpenApiBaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 报废产品收购个人已开额度查询
 *
 * @author zhouwen
 * @date 2024-09-06
 */
public class PostNaturalPersonQuotaQueryMessage {

    @Data
    public static class Request {

        /**
         * 税号
         */
        private String taxNo;

        /**
         * 开票人
         */
        private String issuer;

        /**
         * 自然人名称
         */
        private String name;

        /**
         * 自然人证件类型 默认：201
         */
        private String idType = "201";

        /**
         * 自然人证件号码
         */
        private String idCard;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends OpenApiBaseResponseDto {
        private Result result = new Result();

        @Data
        public static class Result {
            private String taskId;
        }
    }
}