package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 红字信息表申请结果回调消息
 * <p>
 * https://xforceplus.yuque.com/dew9bm/yagacb/hn55gs
 */
@Data
public class PostRedInfoTableResultMessage {

    @Data
    public static class Properties {

        /**
         * 业务编号
         */
        private String businessNo;

        /**
         * 调用方系统
         */
        private String fromSystem;

        /**
         * 租户id
         */
        private String tenantId;
    }

    /**
     * 错误码：成功：1，失败：其他编码
     **/
    private String code = "1";

    /**
     * 描述
     **/
    private String message;

    /**
     * 重试码
     **/
    private String retryCode;

    /**
     * 结果
     **/
    private Result result = new Result();

    @Data
    public static class Result {

        /**
         * 请求流水号
         **/
        private String taskId;

        /**
         * 红字信息表编号
         **/
        private String redLetterNumber;

        /**
         * 红字确认单UUid
         */
        private String redLetterUuid;

        /**
         * 红字信息表状态
         * 01-无需确认
         * 02-销方录入待购方确认
         * 03-购方录入待销方确认
         */
        private String status;

        /**
         * 红字信息表申请日期时间
         * yyyyMMddHHmmss
         */
        private String dateRedApplied;

        /**
         * 是否乐企标识
         */
        private Boolean isNatureSystemFlag;

        /**
         * 是否确认即开票，即经过无需确认或对方确认后，红票会不会自动被开出
         */
        private Boolean isMakeInvoiceAfterConfirm;

        /**
         * 开具状态：有2个枚举：
         * isInvoiced-已开具，
         * notInvoiced-未开具
         */
        private String makeInvoiceStatus;

        /**
         * 红冲金额 [18,2]
         **/
        private BigDecimal redAmount;

        /**
         * 红冲税额 [18,2]
         **/
        private BigDecimal redTaxAmount;

        /**
         * 明细列表
         **/
        private List<Details> detailList;

        @Data
        public static class Details {

            private Integer rowNum;

            /**
             * 原蓝字发票明细序号
             */
            private Integer originInvoiceRowNum;

            /**
             * 明细金额信息
             **/
            private AmountInfo detailAmount;

            @Data
            public static class AmountInfo {

                /**
                 * 不含税金额 [18,2]
                 **/
                private BigDecimal amountWithoutTax;

                /**
                 * 数量 [27,15]
                 **/
                private BigDecimal quantity;

                /**
                 * 税额 [18,2]
                 **/
                private BigDecimal taxAmount;

                /**
                 * 单价 [27,15]
                 **/
                private BigDecimal unitPrice;
            }

            /**
             * 商品信息
             **/
            private ItemInfo item;

            @Data
            public static class ItemInfo {

                /**
                 * 商品名称 [92]
                 **/
                private String itemName;

                /**
                 * 规格型号 [40]
                 **/
                private String specifications;

                /**
                 * 单位 [22]
                 **/
                private String unit;
            }

            /**
             * 税收信息
             **/
            private TaxInfo tax;

            @Data
            public static class TaxInfo {

                /**
                 * 税率 [18,2]
                 **/
                private BigDecimal taxRate;

                /**
                 * 税收分类编码 [20]
                 **/
                private String goodsTaxNo;
            }
        }

        /**
         * 红字确认单对应红票
         */
        private RedInvoice redInvoice;

        @Data
        public static class RedInvoice {

            /**
             * 发票号码
             */
            private String invoiceNo;

            /**
             * 发票类型
             * qc、qs、cz、sz
             */
            private String invoiceType;

            /**
             * 纸票发票代码（纸票红票有值）
             */
            private String paperInvoiceCode;

            /**
             * 纸票发票号码（纸票红票有值）
             */
            private String paperInvoiceNo;

            /**
             * 开票日期时间(yyyyMMddHHmmss)
             */
            private String dateIssued;

            /**
             * 二维码地址（纸票没有此字段）
             */
            private String qrCodeUrl;

            /**
             * 剩余开具额度
             */
            private BigDecimal creditLimit;

            /**
             * 剩余开具额度
             */
            private String remark;
        }
    }
}
