package com.xforceplus.taxware.contract.allelectric.message.enumeration;

import java.util.Arrays;

/**
 * 调度方式
 *
 * @author Bobo
 * @create 2022/7/5 10:54
 * @since 1.0.0
 */
public enum DispatchTypeEnum {
    RMQ("rmq", "rmq队列"),
    API("api", "api同步"),
    SQS("sqs", "sqs队列");

    private String type;
    private String text;

    DispatchTypeEnum(String type, String text) {
        this.type = type;
        this.text = text;
    }

    public static DispatchTypeEnum from(String type) {
        return Arrays.stream(DispatchTypeEnum.values())
                .filter(value -> value.type.equals(type))
                .findAny().orElse(null);
    }

    public String getType() {
        return type;
    }
}
