package com.xforceplus.taxware.contract.allelectric.message.enumeration;

import com.google.common.collect.Lists;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 责任人类型枚举
 *
 * @author Bobo
 * @create 2024/10/14 19:19
 * @since 1.0.0
 */
@Getter
public enum RelatedTypeEnum {

    LEGAL_REPRESENTATIVE("01", "FDDBR", "法定代表人"),
    FINANCE_PERSON("02", "CWFZR", "财务负责人"),
    TAX_OFFICER("03", "BSY", "办税员"),
    ADMINISTRATORS("05", "GLY", "管理员"),
    TICKET_COLLECTOR("07", "LPR", "领票员"),
    SOCIAL_INSURANCE("08", "SBJBR", "社保经办人"),
    ISSUER("09", "KPY", "开票员"),
    SALESPERSON("10", "XSRY", "销售人员");

    private final String code;
    private final String pinyinCode;
    private final String name;

    RelatedTypeEnum(String code, String pinyinCode, String name) {
        this.code = code;
        this.pinyinCode = pinyinCode;
        this.name = name;
    }

    public static RelatedTypeEnum fromCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        return Arrays.stream(RelatedTypeEnum.values())
                .filter(value -> value.code.equals(code))
                .findAny().orElse(null);
    }

    public static RelatedTypeEnum fromPinyinCode(String pinyinCode) {
        if (StringUtils.isBlank(pinyinCode)) {
            return null;
        }
        return Arrays.stream(RelatedTypeEnum.values())
                .filter(value -> value.pinyinCode.equals(pinyinCode))
                .findAny().orElse(null);
    }

    public static RelatedTypeEnum fromName(String name) {
        if (StringUtils.isBlank(name)) {
            return null;
        }
        return Arrays.stream(RelatedTypeEnum.values())
                .filter(value -> value.name.equals(name))
                .findAny().orElse(null);
    }

    public static List<RelatedTypeEnum> fromCodes(String codes) {

        if (StringUtils.isBlank(codes)) {
            return Lists.newArrayList();
        }

        final String[] codesArray = codes.split(",");

        return Arrays.stream(codesArray).map(RelatedTypeEnum::fromCode).filter(Objects::nonNull).collect(Collectors.toList());

    }

    public static String toCodes(List<RelatedTypeEnum> relatedTypeEnumList) {

        if (relatedTypeEnumList == null || relatedTypeEnumList.isEmpty()) {
            return null;
        }

        return relatedTypeEnumList.stream().map(RelatedTypeEnum::getCode).collect(Collectors.joining(","));

    }

}
