package com.xforceplus.taxware.contract.allelectric.message;

import com.xforceplus.taxware.contract.allelectric.message.common.OpenApiBaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 全电打印结果回调消息
 * <p>
 * https://xforceplus.yuque.com/dew9bm/yagacb/atz7p0
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class AeInvoicePrintResultMessage extends OpenApiBaseResponseDto {

    @Data
    public static class Properties {

        /**
         * 业务编号
         */
        private String businessNo;

        /**
         * 调用方系统
         */
        private String fromSystem;

        /**
         * 租户id
         */
        private String tenantId;
    }

    /**
     * 结果
     **/
    private Result result;

    @Data
    public static class Result {

        /**
         * 请求流水号
         **/
        private String taskId;

        /**
         * 纸票发票代码
         **/
        private String paperInvoiceCode;

        /**
         * 纸票发票号码
         */
        private String paperInvoiceNo;

        private String sellerTaxNo;

        /**
         * 全电发票号码
         */
        private String invoiceNo;
    }
}
