package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

/**
 * 全电发票开具开票人状态查询
 * <p>
 * https://api-mock.xforceplus.com/project/141/interface/api/41236
 */
public class GetIssuerStatusMessage {

    @Data
    public static class Response {

        /**
         * 返回码（1为成功 其余为失败）
         */
        private String code = "1";

        /**
         * 返回信息
         */
        private String message = "成功";

        /**
         * 追踪码
         */
        private String traceId;

        /**
         * 结果
         **/
        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 税号
             **/
            private String taxNo;

            /**
             * 开票人
             **/
            private String issuer;

            /**
             * 开票方式
             **/
            private String issueType;

            /**
             * 调度方式
             **/
            private String dispatchType;

            /**
             * 调度目标
             **/
            private String dispatchValue;

            /**
             * 账号ID
             **/
            private String accountId;

            /**
             * 在线标志,true:在线 false:不在线
             **/
            private boolean onlineFlag;

        }
    }
}
