package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

/**
 * 红字信息表操作结果回调消息
 * <p>
 * https://xforceplus.yuque.com/dew9bm/yagacb/ls65dy
 */
@Data
public class PatchRedInfoTableFlowStatusResultMessage {

    @Data
    public static class Properties {

        /**
         * 业务编号
         */
        private String businessNo;

        /**
         * 调用方系统
         */
        private String fromSystem;

        /**
         * 租户id
         */
        private String tenantId;
    }

    /**
     * 错误码：成功：1，失败：其他编码
     **/
    private String code = "1";

    /**
     * 描述
     **/
    private String message;

    /**
     * 结果
     **/
    private Result result;

    @Data
    public static class Result {

        /**
         * 请求流水号
         **/
        private String taskId;

        /**
         * 红字信息表编号
         **/
        private String redLetterNumber;

        /**
         * 是否乐企标识
         */
        private Boolean isNatureSystemFlag;

        /**
         * 红字确认单状态：
         * 01-无需确认
         * 02-销方录入待购方确认
         * 03-购方录入待销方确认
         * 04-购销双方已确认
         * 05-作废（销方录入购方否认）
         * 06-作废（购方录入销方否认）
         * 07-作废（超72小时未确认）
         * 08-作废（发起方已撤销）
         * 09-作废（确认后撤销）
         * 10-作废（异常凭证）
         */
        private String redLetterStatus;

        /**
         * 确认时间: yyyy-MM-dd HH:mm:ss
         */
        private String confirmTime;
    }
}
