package com.xforceplus.taxware.contract.allelectric.message.enumeration;

import com.google.common.collect.Lists;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 计费服务项枚举
 *
 * @author Bobo
 * @create 2023/8/28 10:44
 * @since 1.0.0
 */
public enum ServiceNameEnum {

    MAKE("make", 1, "开票"),
    ASSISTANT("assistant", 2, "抽取"),
    RNFN_APPLY("rnfnApply", 4, "红字信息表申请"),
    RED_LETTER_APPLY("redLetterApply",8 , "红字确认单申请"),
    RED_LETTER_DOWNLOAD("redLetterDownload",16 , "红字确认单同步"),
    AUTHENTICATION("authentication",32 , "认证"),
    AUTHENTICATION_NCP("authenticationNcp",64 , "农产品"),
    AUTHENTICATION_JKS("authenticationJks", 128, "海关缴款书"),
    VERIFICATION("verification", 256, "验真"),
    ENTRY("entry", 512, "发票入账"),
    COLLECTION("collection", 1024, "发票归集"),
    BEMANEGED_TAXDISK("beManegedTaxDisk", 2048, "单盘托管"),
    BEMANEGED_SK("beManegedSk", 4096, "核心板托管"),
    BEMANEGED_RZS("beManegedRzs",8192 , "软证书托管"),
    BEMANEGED_TRUMPRT("beManegedTrumprt", 16384, "虚拟号托管"),
    AUTHENTICATION_WSPZ("authenticationWspz", 32768, "完税凭证"),
    AUTHENTICATION_NCP_JJKC("authenticationNcpjjkc", 65536, "农产品加计扣除"),
    VERIFICATION_MEDICAL("verificationMedical", 131072, "验真医疗票据");

    private final String name;
    private final int numCode;
    private final String desc;

    ServiceNameEnum(String name, int numCode, String desc) {
        this.name = name;
        this.numCode = numCode;
        this.desc = desc;
    }

    public String toName() {
        return this.name;
    }

    public int toNumCode() {
        return this.numCode;
    }

    public String toDesc() {
        return this.desc;
    }

    public static ServiceNameEnum fromName(final String name) {
        return Arrays.stream(ServiceNameEnum.values())
                .filter(x -> Objects.equals(x.name, name))
                .findAny()
                .orElse(null);
    }

    public static List<ServiceNameEnum> fromNameList(final List<String> codeList) {
        if (codeList == null) {
            return Lists.newArrayList();
        }

        return codeList.stream().map(x -> ServiceNameEnum.fromName(x)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<ServiceNameEnum> fromNumCode(final Integer numCode) {
        if (numCode == null || numCode == 0) {
            return Lists.newArrayList();
        }

        return Arrays.stream(ServiceNameEnum.values())
                .filter(x -> (x.numCode & numCode) > 0)
                .collect(Collectors.toList());
    }

    public static int to(final List<ServiceNameEnum> enums) {
        int numCode = 0;
        if (enums == null) {
            return numCode;
        }

        for (ServiceNameEnum eEnum : enums) {
            numCode += eEnum.numCode;
        }
        return numCode;
    }

    public static List<String> toNameList(final List<ServiceNameEnum> enums) {
        if (enums == null) {
            return Lists.newArrayList();
        }

        return enums.stream().map(ServiceNameEnum::toName).collect(Collectors.toList());
    }
}
