package com.xforceplus.taxware.contract.allelectric.message.enumeration;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

@Getter
public enum TaxpayerTypeEnum {

    NORMAL_TAX_PAYER("1", "NormalTaxPayer", "一般纳税人"),
    SMALL_TAX_PAYER("2", "SmallTaxPayer", "小规模纳税人"),
    RE_REGISTERED_SMALL_TAX_PAYER("3", "ReRegisteredSmallTaxPayer", "转登记小规模纳税人"),
    TUTORIAL_PERIOD_NORMAL_TAXPAYER("4", "TutorialPeriodNormalTaxPayer", "辅导期一般纳税人"),
    NATURAL_PERSON("5", "NaturalPerson", "自然人");

    private final String code;
    private final String name;
    private final String text;

    TaxpayerTypeEnum(String code, String name, String text) {
        this.code = code;
        this.name = name;
        this.text = text;
    }

    public static TaxpayerTypeEnum fromCode(String code) {

        if (StringUtils.isBlank(code)) {
            return null;
        }

        return Arrays.stream(TaxpayerTypeEnum.values())
                .filter(typeEnum -> code.equals(typeEnum.getCode()))
                .findAny().orElse(null);
    }

    public static TaxpayerTypeEnum fromName(String name) {

        if (StringUtils.isBlank(name)) {
            return null;
        }

        return Arrays.stream(TaxpayerTypeEnum.values())
                .filter(typeEnum -> name.equals(typeEnum.getName()))
                .findAny().orElse(null);
    }

    public static TaxpayerTypeEnum fromText(String text) {

        return Arrays.stream(TaxpayerTypeEnum.values())
                .filter(typeEnum -> StringUtils.equals(typeEnum.getText(), text))
                .findAny().orElse(null);
    }


}
