package com.xforceplus.taxware.contract.allelectric.message;

import com.google.common.collect.Lists;
import com.xforceplus.taxware.contract.allelectric.message.common.OpenApiBaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 获取全电任一在线队列
 *
 * @author zhouwen
 * @date 2023-07-20 11:10
 */
public class GetAeAnyOnlineQueueMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends OpenApiBaseResponseDto {

        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 任一在线队列名
             */
            private String queueName;

            /**
             * 支持的开具类型: dppt - 电票平台; ns - 乐企
             */
            private List<String> issueTypeList = Lists.newArrayList();
        }
    }
}
