package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

/**
 * 获取风控二维码
 * <p>
 * 契约地址：https://api-mock.xforceplus.com/project/141/interface/api/44088
 *
 * @author Bobo
 * @create 2023/7/5 14:37
 * @since 1.0.0
 */
public class GetServerRiskQrMessage {

    @Data
    public static class Request {

        /**
         * 租户ID-加密
         **/
        private String tenantId;

        /**
         * 税号
         **/
        private String taxNo;

        /**
         * 开票人
         **/
        private String issuer;

        /**
         * 风险二维码类型
         */
        private String qrType = "tax";

    }

    @Data
    public static class Response {

        /**
         * 返回码（1为成功 其余为失败）
         */
        private String code = "1";

        /**
         * 返回信息
         */
        private String message = "成功";

        /**
         * 追踪码
         */
        private String traceId;

        /**
         * 结果
         **/
        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 认证成功标识
             **/
            private boolean successfulFlag;

            /**
             * 二维码
             **/
            private String qrCode;
        }
    }
}
