package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

/**
 * 拆票事件
 * <a href="https://xforceplus.yuque.com/dew9bm/tuk5l5/uaw6h9048gqk8u52">...</a>
 *
 * @author Bobo
 * @create 2024/12/6 16:47
 * @since 1.0.0
 */
public class PhoenixInvoiceSplitEventMessage {

    @Data
    public static class Request {

        /**
         * 批次号
         **/
        private Long batchNo;

        /**
         * 渠道
         **/
        private String channel;

        /**
         * 开票方租户id
         */
        private Long issuerGroupId;

        /**
         * 开票方税号
         */
        private String issuerTaxNo;

        /**
         * 业务单id
         */
        private Long salesbillId;

        /**
         * 业务单号
         */
        private String salesbillNo;

        /**
         * 任务id
         */
        private Long taskId;

        /**
         * 国税发票来源
         * qd - 数电
         * sk - 税控
         */
        private String taxInvoiceSource;
    }
}
