package com.xforceplus.taxware.contract.allelectric.message;

import com.google.common.collect.Lists;
import com.xforceplus.taxware.contract.allelectric.message.common.OpenApiBaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 数电红字确认单同步结果
 * 替代 RnfnDownloadResultMessage
 */
@Data
public class RedLetterDownloadResultMessage {

    @Data
    public static class Properties {

        /**
         * 业务编号
         */
        private String businessNo;

        /**
         * 租户id
         */
        private String tenantId;

        /**
         * 调用方
         */
        private String fromSystem;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends OpenApiBaseResponseDto {

        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 请求流水号
             */
            private String taskId;

            /**
             * 数电红字确认单列表
             */
            private List<RedLetterDto> redLetterList = Lists.newArrayList();

            @Data
            public static class RedLetterDto {

                /**
                 * 申请身份
                 */
                private String applyIdentity;

                /**
                 * 原蓝票号码 (全电)
                 */
                private String originalInvoiceNo;

                /**
                 * 原蓝票发票代码 (数电纸票、税控票用)
                 */
                private String originalBlueInvoiceCode;

                /**
                 * 原蓝票发票号码 (数电纸票、税控票用)
                 */
                private String originalBlueInvoiceNo;

                /**
                 * 原蓝票发票类型
                 */
                private String originalInvoiceType;

                /**
                 * 原蓝票特定要素类型
                 */
                private String originalInvoiceStyleType;

                /**
                 * 红票发票号码
                 */
                private String redInvoiceNo;

                /**
                 * 红字通知单编号
                 */
                private String redInformationNo;

                /**
                 * 红字确认单申请日期,格式:yyyy-MM-dd HH:mm:ss
                 */
                private String applyDate;

                /**
                 * 红字确认单确认日期，格式yyyy-MM-dd HH:mm:ss
                 */
                private String confirmTime;

                /**
                 * 发票金额
                 */
                private BigDecimal redAmount;

                /**
                 * 发票税额 (18位，2位小数)
                 */
                private BigDecimal redTaxAmount;

                /**
                 * 冲红原因
                 */
                private String applyReason;

                /**
                 * 状态
                 */
                private String status;

                /**
                 * 开具状态
                 */
                private String confirmStatus;

                /**
                 * 确认即开票：（红字确认单是否确认后已自动开具红票）
                 * 1 - 已开具
                 * 0 - 未开具
                 * 空 - 未知
                 */
                private String confirmMake;

                /**
                 * 开票日期: yyyy-MM-dd HH:mm:ss
                 */
                private String invoiceDate;

                /**
                 * 增值税用途状态
                 */
                private String vaTaxPurpose;

                /**
                 * 消费税用途状态
                 */
                private String excisePurpose;

                /**
                 * 入账状态
                 */
                private String inAccountStatus;

                /**
                 * 销方信息
                 */
                private SellerDto seller;

                /**
                 * 购方信息
                 */
                private BuyerDto buyer;

                /**
                 * 二手车卖方信息
                 */
                private UsedVehicleSellerDto usedVehicleSeller;

                /**
                 * 明细
                 */
                private List<RnfnDetailDto> detailList;

                @Data
                public static class SellerDto {

                    /**
                     * 销方名称
                     */
                    private String sellerName;

                    /**
                     * 销方税号
                     */
                    private String sellerTaxNo;
                }

                @Data
                public static class BuyerDto {

                    /**
                     * 购方名称
                     */
                    private String buyerName;

                    /**
                     * 购方税号
                     */
                    private String buyerTaxNo;
                }

                /**
                 * 二手车卖方信息
                 */
                @Data
                public static class UsedVehicleSellerDto {

                    /**
                     * 二手车卖方名称
                     */
                    private String usedVehicleSellerName;

                    /**
                     * 二手车卖方税号
                     */
                    private String usedVehicleSellerTaxNo;
                }

                @Data
                public static class RnfnDetailDto {

                    /**
                     * 明细序号: 从1开始, 1、2、3......
                     */
                    private Integer rowNum;

                    /**
                     * 对应蓝票明细序号: 从1开始
                     */
                    private Integer originInvoiceRowNum;

                    /**
                     * 明细金额
                     */
                    private DetailAmountDto detailAmount;

                    /**
                     * 商品信息
                     */
                    private ItemDto item;

                    /**
                     * 税收信息
                     */
                    private TaxDto tax;

                    @Data
                    public static class DetailAmountDto {

                        /**
                         * 不含税金额
                         */
                        private BigDecimal amountWithoutTax;

                        /**
                         * 数量
                         */
                        private BigDecimal quantity;

                        /**
                         * 单价
                         */
                        private BigDecimal unitPrice;

                        /**
                         * 税额
                         */
                        private BigDecimal taxAmount;
                    }

                    @Data
                    public static class ItemDto {

                        /**
                         * 商品名称
                         */
                        private String itemName;

                        /**
                         * 规格型号
                         */
                        private String specifications;

                        /**
                         * 单位
                         */
                        private String unit;
                    }

                    @Data
                    public static class TaxDto {

                        /**
                         * 税率
                         */
                        private BigDecimal taxRate;

                        /**
                         * 税编
                         */
                        private String taxClassCode;
                    }
                }
            }
        }
    }
}
