package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

@Data
public class VoucherResultMessage {

    /**
     * 1 = 成功。其他返回具体的错误码
     */
    private String code;

    /**
     * 描述信息
     */
    private String message;

    /**
     * 结果
     */
    private Result result = new Result();


    @Data
    public static class Result {

        /**
         * 发票号码
         */
        private String invoiceNo;

        /**
         * 板式文件
         */
        private Voucher voucher = new Voucher();

        @Data
        public static class Voucher {
            private String ofdUrl;
            private Boolean isOfdPreset = false;
            private String pdfUrl;
            private Boolean isPdfPreset = false;
            private String xmlUrl;
            private Boolean isXmlPreset = false;
            private String imgUrl;
            private String qrCodeUrl;
        }
    }
}
