package com.xforceplus.taxware.contract.allelectric.message.enumeration;

import com.google.common.collect.Lists;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 全电登录方式
 *
 * @author Bobo
 * @create 2023/12/14 14:42
 * @since 1.0.0
 */
@Getter
public enum AeLoginModelEnum {

    TAX_APP(1, "tax", 3, "税务APP"),
    PERSON_APP(2, "person", 5, "个税APP"),
    ACCOUNT(4, "account", 2, "账号密码"),
    SMS(8, "sms", 1, "短信验证码登录"),
    TRUMPET(16, "trumpet", 1, "虚拟小号登录"),
    P4(32, "p4", 1, "P4供应商登录"),
    P7(64, "p7", 1, "P7供应商登录");

    private final Integer code;
    private final String model;
    private final Integer componentVersion;
    private final String text;

    AeLoginModelEnum(Integer code, String model, Integer componentVersion, String text) {
        this.code = code;
        this.model = model;
        this.componentVersion = componentVersion;
        this.text = text;
    }

    public static AeLoginModelEnum from(String model) {
        return Arrays.stream(AeLoginModelEnum.values())
                .filter(value -> value.model.equals(model))
                .findAny().orElse(null);
    }

    public static List<AeLoginModelEnum> fromCode(Integer code) {
        if (code == null || code == 0) {
            return Lists.newArrayList();
        }

        return Arrays.stream(AeLoginModelEnum.values())
                .filter(x -> (x.code & code) > 0)
                .collect(Collectors.toList());
    }

    public static List<String> toModeList(List<AeLoginModelEnum> aeLoginModelEnumList) {
        if (aeLoginModelEnumList == null) {
            return Lists.newArrayList();
        }

        return aeLoginModelEnumList.stream().map(AeLoginModelEnum::getModel).collect(Collectors.toList());
    }
}
