/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.check.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.chestnut.check.model.common.Alias;
import com.xforceplus.taxware.chestnut.check.model.common.ValidateResult;
import com.xforceplus.taxware.chestnut.check.model.model.BaseInvoiceInfo;
import com.xforceplus.taxware.chestnut.check.model.model.BuyerInfo;
import com.xforceplus.taxware.chestnut.check.model.model.InvoiceAmountInfo;
import com.xforceplus.taxware.chestnut.check.model.model.OperatorInfo;
import com.xforceplus.taxware.chestnut.check.model.model.RedLetterInfo;
import com.xforceplus.taxware.chestnut.check.model.model.SellerInfo;
import com.xforceplus.taxware.chestnut.check.model.util.BasicValidator;
import java.math.BigDecimal;
import java.util.List;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.ScriptAssert;

public class AllElectricInvoiceBaseValidationModel {

    public static class Additional {
        @Alias(value="\u9644\u52a0\u8981\u7d20\u540d\u79f0")
        @Length(max=200)
        @JSONField(name="fjysmc")
        private @Length(max=200) String additionalElementName;
        @Alias(value="\u9644\u52a0\u8981\u7d20\u7c7b\u578b")
        @Length(max=200)
        @JSONField(name="fjyslx")
        private @Length(max=200) String additionalElementType;
        @Alias(value="\u9644\u52a0\u8981\u7d20\u503c")
        @Length(max=200)
        @JSONField(name="fjysz")
        private @Length(max=200) String additionalElementValue;

        public String getAdditionalElementName() {
            return this.additionalElementName;
        }

        public String getAdditionalElementType() {
            return this.additionalElementType;
        }

        public String getAdditionalElementValue() {
            return this.additionalElementValue;
        }

        public void setAdditionalElementName(String additionalElementName) {
            this.additionalElementName = additionalElementName;
        }

        public void setAdditionalElementType(String additionalElementType) {
            this.additionalElementType = additionalElementType;
        }

        public void setAdditionalElementValue(String additionalElementValue) {
            this.additionalElementValue = additionalElementValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Additional)) {
                return false;
            }
            Additional other = (Additional)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$additionalElementName = this.getAdditionalElementName();
            String other$additionalElementName = other.getAdditionalElementName();
            if (this$additionalElementName == null ? other$additionalElementName != null : !this$additionalElementName.equals(other$additionalElementName)) {
                return false;
            }
            String this$additionalElementType = this.getAdditionalElementType();
            String other$additionalElementType = other.getAdditionalElementType();
            if (this$additionalElementType == null ? other$additionalElementType != null : !this$additionalElementType.equals(other$additionalElementType)) {
                return false;
            }
            String this$additionalElementValue = this.getAdditionalElementValue();
            String other$additionalElementValue = other.getAdditionalElementValue();
            return !(this$additionalElementValue == null ? other$additionalElementValue != null : !this$additionalElementValue.equals(other$additionalElementValue));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Additional;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $additionalElementName = this.getAdditionalElementName();
            result = result * 59 + ($additionalElementName == null ? 43 : $additionalElementName.hashCode());
            String $additionalElementType = this.getAdditionalElementType();
            result = result * 59 + ($additionalElementType == null ? 43 : $additionalElementType.hashCode());
            String $additionalElementValue = this.getAdditionalElementValue();
            result = result * 59 + ($additionalElementValue == null ? 43 : $additionalElementValue.hashCode());
            return result;
        }

        public String toString() {
            return "AllElectricInvoiceBaseValidationModel.Additional(additionalElementName=" + this.getAdditionalElementName() + ", additionalElementType=" + this.getAdditionalElementType() + ", additionalElementValue=" + this.getAdditionalElementValue() + ")";
        }
    }

    @ScriptAssert.List(value={@ScriptAssert(lang="javascript", script="com.xforceplus.taxware.chestnut.contract.model.PostUploadAllElectricInvoiceResultMessage.InvoiceDetail.isValidUnionInfo(_this)", message="\u6570\u91cf\uff0c\u5355\u4ef7\u548c\u5355\u4f4d\u6709\u4e00\u9879\u662f\u975e\u7a7a\uff0c\u5219\u53e6\u5916\u4e24\u9879\u4e5f\u8981\u975e\u7a7a")})
    public static class InvoiceDetail {
        @Alias(value="\u660e\u7ec6\u5e8f\u53f7")
        @NotNull
        @Digits(integer=8, fraction=0)
        @JSONField(name="mxxh")
        private @NotNull @Digits(integer=8, fraction=0) Integer rowNum;
        @Alias(value="\u5bf9\u5e94\u84dd\u5b57\u53d1\u7968\u660e\u7ec6\u5e8f\u53f7")
        @Digits(integer=8, fraction=0)
        @JSONField(name="dylzfpmxxh")
        private @Digits(integer=8, fraction=0) Integer originalRowNum;
        @Alias(value="\u9879\u76ee\u540d\u79f0")
        @NotEmpty
        @Length(max=600)
        @JSONField(name="xmmc")
        private @NotEmpty @Length(max=600) String itemName;
        @Alias(value="\u89c4\u683c\u578b\u53f7")
        @Length(max=150)
        @JSONField(name="ggxh")
        private @Length(max=150) String specifications;
        @Alias(value="\u5355\u4f4d")
        @Length(max=300)
        @JSONField(name="dw")
        private @Length(max=300) String unit;
        @Alias(value="\u6570\u91cf")
        @Length(max=25)
        @JSONField(name="sl")
        private @Length(max=25) String quantity;
        @Alias(value="\u5355\u4ef7")
        @Length(max=25)
        @JSONField(name="dj")
        private @Length(max=25) String unitPrice;
        @Alias(value="\u91d1\u989d")
        @NotNull
        @Digits(integer=18, fraction=2)
        @JSONField(name="je")
        private @NotNull @Digits(integer=18, fraction=2) BigDecimal amountWithoutTax;
        @Alias(value="\u589e\u503c\u7a0e\u7a0e\u7387")
        @NotNull
        @Digits(integer=16, fraction=6)
        @JSONField(name="slv")
        private @NotNull @Digits(integer=16, fraction=6) BigDecimal taxRate;
        @Alias(value="\u7a0e\u989d")
        @NotNull
        @Digits(integer=18, fraction=2)
        @JSONField(name="se")
        private @NotNull @Digits(integer=18, fraction=2) BigDecimal taxAmount;
        @Alias(value="\u542b\u7a0e\u91d1\u989d")
        @NotNull
        @Digits(integer=18, fraction=2)
        @JSONField(name="hsje")
        private @NotNull @Digits(integer=18, fraction=2) BigDecimal amountWithTax;
        @Alias(value="\u6263\u9664\u989d")
        @Digits(integer=18, fraction=2)
        @JSONField(name="kce")
        private @Digits(integer=18, fraction=2) BigDecimal deduction;
        @Alias(value="\u5546\u54c1\u548c\u670d\u52a1\u7a0e\u6536\u5206\u7c7b\u5408\u5e76\u7f16\u7801")
        @NotEmpty
        @Length(max=19)
        @JSONField(name="sphfwssflhbbm")
        private @NotEmpty @Length(max=19) String goodsTaxNo;
        @Alias(value="\u53d1\u7968\u884c\u6027\u8d28")
        @NotEmpty
        @Length(max=2)
        @Pattern(regexp="0[0-2]")
        @JSONField(name="fphxz")
        private @NotEmpty @Length(max=2) @Pattern(regexp="0[0-2]") String discountType;
        @Alias(value="\u4f18\u60e0\u653f\u7b56\u6807\u8bc6")
        @Pattern(regexp="0[1-9]|1[0-8]")
        @JSONField(name="yhzcbs")
        private @Pattern(regexp="0[1-9]|1[0-8]") String taxIncentivesType;

        public static boolean isValidUnionInfo(InvoiceDetail invoiceDetail) {
            if (invoiceDetail.getUnit() != null && invoiceDetail.getUnit().trim().length() > 0 || invoiceDetail.getUnitPrice() != null && invoiceDetail.getUnitPrice().trim().length() > 0 || invoiceDetail.getQuantity() != null && invoiceDetail.getQuantity().trim().length() > 0) {
                return invoiceDetail.getUnit() != null && invoiceDetail.getUnit().trim().length() > 0 && invoiceDetail.getUnitPrice() != null && invoiceDetail.getUnitPrice().trim().length() > 0 && invoiceDetail.getQuantity() != null && invoiceDetail.getQuantity().trim().length() > 0;
            }
            return true;
        }

        public ValidateResult validate() {
            ValidateResult result = BasicValidator.validate(this);
            if (result.isSuccess()) {
                result = BasicValidator.mergeValidateResult(result, this.validateData());
            }
            return result;
        }

        ValidateResult validateData() {
            ValidateResult result = ValidateResult.success();
            result = BasicValidator.mergeValidateResult(result, this.isValidAmount());
            result = BasicValidator.mergeValidateResult(result, this.isValidTaxAmount());
            return result;
        }

        private ValidateResult isValidAmount() {
            BigDecimal quantity;
            if (this.getUnitPrice() == null || this.getQuantity() == null) {
                return ValidateResult.success();
            }
            BigDecimal unitPrice = new BigDecimal(this.getUnitPrice());
            if (unitPrice.multiply(quantity = new BigDecimal(this.getQuantity())).subtract(this.getAmountWithoutTax()).abs().compareTo(BigDecimal.valueOf(0.01)) > 0) {
                return ValidateResult.fail("\u5355\u884c\u91d1\u989d\u8d85\u8fc7\u6700\u5927\u8bef\u5dee0.01");
            }
            return ValidateResult.success();
        }

        private ValidateResult isValidTaxAmount() {
            if (this.getAmountWithoutTax().multiply(this.getTaxRate()).subtract(this.getTaxAmount()).abs().compareTo(BigDecimal.valueOf(0.06)) > 0) {
                return ValidateResult.fail("\u5355\u884c\u7a0e\u989d\u8d85\u8fc7\u6700\u5927\u8bef\u5dee0.06");
            }
            return ValidateResult.success();
        }

        public Integer getRowNum() {
            return this.rowNum;
        }

        public Integer getOriginalRowNum() {
            return this.originalRowNum;
        }

        public String getItemName() {
            return this.itemName;
        }

        public String getSpecifications() {
            return this.specifications;
        }

        public String getUnit() {
            return this.unit;
        }

        public String getQuantity() {
            return this.quantity;
        }

        public String getUnitPrice() {
            return this.unitPrice;
        }

        public BigDecimal getAmountWithoutTax() {
            return this.amountWithoutTax;
        }

        public BigDecimal getTaxRate() {
            return this.taxRate;
        }

        public BigDecimal getTaxAmount() {
            return this.taxAmount;
        }

        public BigDecimal getAmountWithTax() {
            return this.amountWithTax;
        }

        public BigDecimal getDeduction() {
            return this.deduction;
        }

        public String getGoodsTaxNo() {
            return this.goodsTaxNo;
        }

        public String getDiscountType() {
            return this.discountType;
        }

        public String getTaxIncentivesType() {
            return this.taxIncentivesType;
        }

        public void setRowNum(Integer rowNum) {
            this.rowNum = rowNum;
        }

        public void setOriginalRowNum(Integer originalRowNum) {
            this.originalRowNum = originalRowNum;
        }

        public void setItemName(String itemName) {
            this.itemName = itemName;
        }

        public void setSpecifications(String specifications) {
            this.specifications = specifications;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public void setQuantity(String quantity) {
            this.quantity = quantity;
        }

        public void setUnitPrice(String unitPrice) {
            this.unitPrice = unitPrice;
        }

        public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
            this.amountWithoutTax = amountWithoutTax;
        }

        public void setTaxRate(BigDecimal taxRate) {
            this.taxRate = taxRate;
        }

        public void setTaxAmount(BigDecimal taxAmount) {
            this.taxAmount = taxAmount;
        }

        public void setAmountWithTax(BigDecimal amountWithTax) {
            this.amountWithTax = amountWithTax;
        }

        public void setDeduction(BigDecimal deduction) {
            this.deduction = deduction;
        }

        public void setGoodsTaxNo(String goodsTaxNo) {
            this.goodsTaxNo = goodsTaxNo;
        }

        public void setDiscountType(String discountType) {
            this.discountType = discountType;
        }

        public void setTaxIncentivesType(String taxIncentivesType) {
            this.taxIncentivesType = taxIncentivesType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvoiceDetail)) {
                return false;
            }
            InvoiceDetail other = (InvoiceDetail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$rowNum = this.getRowNum();
            Integer other$rowNum = other.getRowNum();
            if (this$rowNum == null ? other$rowNum != null : !((Object)this$rowNum).equals(other$rowNum)) {
                return false;
            }
            Integer this$originalRowNum = this.getOriginalRowNum();
            Integer other$originalRowNum = other.getOriginalRowNum();
            if (this$originalRowNum == null ? other$originalRowNum != null : !((Object)this$originalRowNum).equals(other$originalRowNum)) {
                return false;
            }
            String this$itemName = this.getItemName();
            String other$itemName = other.getItemName();
            if (this$itemName == null ? other$itemName != null : !this$itemName.equals(other$itemName)) {
                return false;
            }
            String this$specifications = this.getSpecifications();
            String other$specifications = other.getSpecifications();
            if (this$specifications == null ? other$specifications != null : !this$specifications.equals(other$specifications)) {
                return false;
            }
            String this$unit = this.getUnit();
            String other$unit = other.getUnit();
            if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
                return false;
            }
            String this$quantity = this.getQuantity();
            String other$quantity = other.getQuantity();
            if (this$quantity == null ? other$quantity != null : !this$quantity.equals(other$quantity)) {
                return false;
            }
            String this$unitPrice = this.getUnitPrice();
            String other$unitPrice = other.getUnitPrice();
            if (this$unitPrice == null ? other$unitPrice != null : !this$unitPrice.equals(other$unitPrice)) {
                return false;
            }
            BigDecimal this$amountWithoutTax = this.getAmountWithoutTax();
            BigDecimal other$amountWithoutTax = other.getAmountWithoutTax();
            if (this$amountWithoutTax == null ? other$amountWithoutTax != null : !((Object)this$amountWithoutTax).equals(other$amountWithoutTax)) {
                return false;
            }
            BigDecimal this$taxRate = this.getTaxRate();
            BigDecimal other$taxRate = other.getTaxRate();
            if (this$taxRate == null ? other$taxRate != null : !((Object)this$taxRate).equals(other$taxRate)) {
                return false;
            }
            BigDecimal this$taxAmount = this.getTaxAmount();
            BigDecimal other$taxAmount = other.getTaxAmount();
            if (this$taxAmount == null ? other$taxAmount != null : !((Object)this$taxAmount).equals(other$taxAmount)) {
                return false;
            }
            BigDecimal this$amountWithTax = this.getAmountWithTax();
            BigDecimal other$amountWithTax = other.getAmountWithTax();
            if (this$amountWithTax == null ? other$amountWithTax != null : !((Object)this$amountWithTax).equals(other$amountWithTax)) {
                return false;
            }
            BigDecimal this$deduction = this.getDeduction();
            BigDecimal other$deduction = other.getDeduction();
            if (this$deduction == null ? other$deduction != null : !((Object)this$deduction).equals(other$deduction)) {
                return false;
            }
            String this$goodsTaxNo = this.getGoodsTaxNo();
            String other$goodsTaxNo = other.getGoodsTaxNo();
            if (this$goodsTaxNo == null ? other$goodsTaxNo != null : !this$goodsTaxNo.equals(other$goodsTaxNo)) {
                return false;
            }
            String this$discountType = this.getDiscountType();
            String other$discountType = other.getDiscountType();
            if (this$discountType == null ? other$discountType != null : !this$discountType.equals(other$discountType)) {
                return false;
            }
            String this$taxIncentivesType = this.getTaxIncentivesType();
            String other$taxIncentivesType = other.getTaxIncentivesType();
            return !(this$taxIncentivesType == null ? other$taxIncentivesType != null : !this$taxIncentivesType.equals(other$taxIncentivesType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InvoiceDetail;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $rowNum = this.getRowNum();
            result = result * 59 + ($rowNum == null ? 43 : ((Object)$rowNum).hashCode());
            Integer $originalRowNum = this.getOriginalRowNum();
            result = result * 59 + ($originalRowNum == null ? 43 : ((Object)$originalRowNum).hashCode());
            String $itemName = this.getItemName();
            result = result * 59 + ($itemName == null ? 43 : $itemName.hashCode());
            String $specifications = this.getSpecifications();
            result = result * 59 + ($specifications == null ? 43 : $specifications.hashCode());
            String $unit = this.getUnit();
            result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
            String $quantity = this.getQuantity();
            result = result * 59 + ($quantity == null ? 43 : $quantity.hashCode());
            String $unitPrice = this.getUnitPrice();
            result = result * 59 + ($unitPrice == null ? 43 : $unitPrice.hashCode());
            BigDecimal $amountWithoutTax = this.getAmountWithoutTax();
            result = result * 59 + ($amountWithoutTax == null ? 43 : ((Object)$amountWithoutTax).hashCode());
            BigDecimal $taxRate = this.getTaxRate();
            result = result * 59 + ($taxRate == null ? 43 : ((Object)$taxRate).hashCode());
            BigDecimal $taxAmount = this.getTaxAmount();
            result = result * 59 + ($taxAmount == null ? 43 : ((Object)$taxAmount).hashCode());
            BigDecimal $amountWithTax = this.getAmountWithTax();
            result = result * 59 + ($amountWithTax == null ? 43 : ((Object)$amountWithTax).hashCode());
            BigDecimal $deduction = this.getDeduction();
            result = result * 59 + ($deduction == null ? 43 : ((Object)$deduction).hashCode());
            String $goodsTaxNo = this.getGoodsTaxNo();
            result = result * 59 + ($goodsTaxNo == null ? 43 : $goodsTaxNo.hashCode());
            String $discountType = this.getDiscountType();
            result = result * 59 + ($discountType == null ? 43 : $discountType.hashCode());
            String $taxIncentivesType = this.getTaxIncentivesType();
            result = result * 59 + ($taxIncentivesType == null ? 43 : $taxIncentivesType.hashCode());
            return result;
        }

        public String toString() {
            return "AllElectricInvoiceBaseValidationModel.InvoiceDetail(rowNum=" + this.getRowNum() + ", originalRowNum=" + this.getOriginalRowNum() + ", itemName=" + this.getItemName() + ", specifications=" + this.getSpecifications() + ", unit=" + this.getUnit() + ", quantity=" + this.getQuantity() + ", unitPrice=" + this.getUnitPrice() + ", amountWithoutTax=" + this.getAmountWithoutTax() + ", taxRate=" + this.getTaxRate() + ", taxAmount=" + this.getTaxAmount() + ", amountWithTax=" + this.getAmountWithTax() + ", deduction=" + this.getDeduction() + ", goodsTaxNo=" + this.getGoodsTaxNo() + ", discountType=" + this.getDiscountType() + ", taxIncentivesType=" + this.getTaxIncentivesType() + ")";
        }
    }

    @ScriptAssert.List(value={@ScriptAssert(lang="javascript", script="com.xforceplus.taxware.chestnut.contract.model.UploadAllElectricInvoiceResultMessage.InvoiceInfo.isValidNotEmptyRedLetterInfo(_this)", message="\u6807\u5fd7\u4e3a\u7ea2\u7968\uff0c\u5bf9\u5e94\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7\u548cUUID\u5747\u4e0d\u80fd\u4e3a\u7a7a")})
    public static class InvoiceInfo {
        private BaseInvoiceInfo invoiceBaseInfo;
        private SellerInfo sellerInfo;
        private BuyerInfo buyerInfo;
        private InvoiceAmountInfo invoiceAmountInfo;
        private OperatorInfo operatorInfo;
        private final RedLetterInfo redLetterInfo;
        private List<InvoiceDetail> invoiceDetailList;

        public static boolean isValidNotEmptyRedLetterInfo(InvoiceInfo invoiceInfo) {
            BaseInvoiceInfo invoiceBaseInfo = invoiceInfo.getInvoiceBaseInfo();
            RedLetterInfo redInfo = invoiceInfo.getRedLetterInfo();
            if ("1".equals(invoiceBaseInfo.getInvoiceFlag()) && redInfo != null) {
                return redInfo.getRedLetterNumber() != null && redInfo.getRedLetterNumber().trim().length() > 0 && redInfo.getRedLetterUuid() != null && redInfo.getRedLetterUuid().trim().length() > 0;
            }
            return true;
        }

        public ValidateResult validate() {
            ValidateResult result = BasicValidator.validate(this);
            List<InvoiceDetail> detailList = this.getInvoiceDetailList();
            if (detailList == null || detailList.size() == 0) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u660e\u7ec6\u884c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
                return result;
            }
            for (InvoiceDetail detail : detailList) {
                ValidateResult validateResult = BasicValidator.validate(detail, "" + detail.getRowNum());
                result = BasicValidator.mergeValidateResult(result, validateResult);
            }
            if (result.isSuccess()) {
                result = BasicValidator.mergeValidateResult(result, this.validateData());
            }
            return result;
        }

        private ValidateResult validateData() {
            ValidateResult result = ValidateResult.success();
            List<InvoiceDetail> detailList = this.getInvoiceDetailList();
            BigDecimal detailTotalAmount = BigDecimal.valueOf(0L);
            BigDecimal detailTotalTaxAmount = BigDecimal.valueOf(0L);
            BigDecimal invoiceTotalAmount = this.getInvoiceAmountInfo().getAmountWithTax();
            BigDecimal invoiceTotalTaxAmount = this.getInvoiceAmountInfo().getTaxAmount();
            for (int i = 0; i < detailList.size(); ++i) {
                InvoiceDetail detail = detailList.get(i);
                ValidateResult validateDataResult = detail.validateData();
                result = BasicValidator.mergeValidateResult(result, validateDataResult);
                detailTotalAmount = detailTotalAmount.add(detail.getAmountWithTax());
                detailTotalTaxAmount = detailTotalTaxAmount.add(detail.getAmountWithoutTax().multiply(detail.getTaxRate()));
                if ("01".equals(detail.getDiscountType()) && !detailList.get(i - 1).getItemName().equals(detail.getItemName())) {
                    result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%s\u884c\u6298\u6263\u884c\u5546\u54c1\u540d\u79f0\u548c\u539f\u53d1\u7968\u884c\u4e0d\u4e00\u81f4", i + 1)));
                }
                if (!"1".equals(this.getInvoiceBaseInfo().getInvoiceFlag()) || detail.getOriginalRowNum() != null) continue;
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail(String.format("\u7b2c%s\u884c\u5bf9\u5e94\u5bf9\u5e94\u84dd\u5b57\u53d1\u7968\u660e\u7ec6\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a", i + 1)));
            }
            if (detailTotalAmount.subtract(invoiceTotalAmount).abs().compareTo(BigDecimal.valueOf(0.01)) > 0) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u660e\u7ec6\u884c\u5408\u8ba1\u91d1\u989d\u8d85\u8fc7\u6700\u5927\u8bef\u5dee0.01\u5143"));
            }
            if (detailTotalTaxAmount.subtract(invoiceTotalTaxAmount).abs().compareTo(BigDecimal.valueOf(1.27)) > 0) {
                result = BasicValidator.mergeValidateResult(result, ValidateResult.fail("\u660e\u7ec6\u884c\u5408\u8ba1\u7a0e\u989d\u8d85\u8fc7\u6700\u5927\u8bef\u5dee1.27\u5143"));
            }
            return result;
        }

        public InvoiceInfo(RedLetterInfo redLetterInfo) {
            this.redLetterInfo = redLetterInfo;
        }

        public BaseInvoiceInfo getInvoiceBaseInfo() {
            return this.invoiceBaseInfo;
        }

        public SellerInfo getSellerInfo() {
            return this.sellerInfo;
        }

        public BuyerInfo getBuyerInfo() {
            return this.buyerInfo;
        }

        public InvoiceAmountInfo getInvoiceAmountInfo() {
            return this.invoiceAmountInfo;
        }

        public OperatorInfo getOperatorInfo() {
            return this.operatorInfo;
        }

        public RedLetterInfo getRedLetterInfo() {
            return this.redLetterInfo;
        }

        public List<InvoiceDetail> getInvoiceDetailList() {
            return this.invoiceDetailList;
        }

        public void setInvoiceBaseInfo(BaseInvoiceInfo invoiceBaseInfo) {
            this.invoiceBaseInfo = invoiceBaseInfo;
        }

        public void setSellerInfo(SellerInfo sellerInfo) {
            this.sellerInfo = sellerInfo;
        }

        public void setBuyerInfo(BuyerInfo buyerInfo) {
            this.buyerInfo = buyerInfo;
        }

        public void setInvoiceAmountInfo(InvoiceAmountInfo invoiceAmountInfo) {
            this.invoiceAmountInfo = invoiceAmountInfo;
        }

        public void setOperatorInfo(OperatorInfo operatorInfo) {
            this.operatorInfo = operatorInfo;
        }

        public void setInvoiceDetailList(List<InvoiceDetail> invoiceDetailList) {
            this.invoiceDetailList = invoiceDetailList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvoiceInfo)) {
                return false;
            }
            InvoiceInfo other = (InvoiceInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BaseInvoiceInfo this$invoiceBaseInfo = this.getInvoiceBaseInfo();
            BaseInvoiceInfo other$invoiceBaseInfo = other.getInvoiceBaseInfo();
            if (this$invoiceBaseInfo == null ? other$invoiceBaseInfo != null : !((Object)this$invoiceBaseInfo).equals(other$invoiceBaseInfo)) {
                return false;
            }
            SellerInfo this$sellerInfo = this.getSellerInfo();
            SellerInfo other$sellerInfo = other.getSellerInfo();
            if (this$sellerInfo == null ? other$sellerInfo != null : !((Object)this$sellerInfo).equals(other$sellerInfo)) {
                return false;
            }
            BuyerInfo this$buyerInfo = this.getBuyerInfo();
            BuyerInfo other$buyerInfo = other.getBuyerInfo();
            if (this$buyerInfo == null ? other$buyerInfo != null : !((Object)this$buyerInfo).equals(other$buyerInfo)) {
                return false;
            }
            InvoiceAmountInfo this$invoiceAmountInfo = this.getInvoiceAmountInfo();
            InvoiceAmountInfo other$invoiceAmountInfo = other.getInvoiceAmountInfo();
            if (this$invoiceAmountInfo == null ? other$invoiceAmountInfo != null : !((Object)this$invoiceAmountInfo).equals(other$invoiceAmountInfo)) {
                return false;
            }
            OperatorInfo this$operatorInfo = this.getOperatorInfo();
            OperatorInfo other$operatorInfo = other.getOperatorInfo();
            if (this$operatorInfo == null ? other$operatorInfo != null : !((Object)this$operatorInfo).equals(other$operatorInfo)) {
                return false;
            }
            RedLetterInfo this$redLetterInfo = this.getRedLetterInfo();
            RedLetterInfo other$redLetterInfo = other.getRedLetterInfo();
            if (this$redLetterInfo == null ? other$redLetterInfo != null : !((Object)this$redLetterInfo).equals(other$redLetterInfo)) {
                return false;
            }
            List<InvoiceDetail> this$invoiceDetailList = this.getInvoiceDetailList();
            List<InvoiceDetail> other$invoiceDetailList = other.getInvoiceDetailList();
            return !(this$invoiceDetailList == null ? other$invoiceDetailList != null : !((Object)this$invoiceDetailList).equals(other$invoiceDetailList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InvoiceInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BaseInvoiceInfo $invoiceBaseInfo = this.getInvoiceBaseInfo();
            result = result * 59 + ($invoiceBaseInfo == null ? 43 : ((Object)$invoiceBaseInfo).hashCode());
            SellerInfo $sellerInfo = this.getSellerInfo();
            result = result * 59 + ($sellerInfo == null ? 43 : ((Object)$sellerInfo).hashCode());
            BuyerInfo $buyerInfo = this.getBuyerInfo();
            result = result * 59 + ($buyerInfo == null ? 43 : ((Object)$buyerInfo).hashCode());
            InvoiceAmountInfo $invoiceAmountInfo = this.getInvoiceAmountInfo();
            result = result * 59 + ($invoiceAmountInfo == null ? 43 : ((Object)$invoiceAmountInfo).hashCode());
            OperatorInfo $operatorInfo = this.getOperatorInfo();
            result = result * 59 + ($operatorInfo == null ? 43 : ((Object)$operatorInfo).hashCode());
            RedLetterInfo $redLetterInfo = this.getRedLetterInfo();
            result = result * 59 + ($redLetterInfo == null ? 43 : ((Object)$redLetterInfo).hashCode());
            List<InvoiceDetail> $invoiceDetailList = this.getInvoiceDetailList();
            result = result * 59 + ($invoiceDetailList == null ? 43 : ((Object)$invoiceDetailList).hashCode());
            return result;
        }

        public String toString() {
            return "AllElectricInvoiceBaseValidationModel.InvoiceInfo(invoiceBaseInfo=" + this.getInvoiceBaseInfo() + ", sellerInfo=" + this.getSellerInfo() + ", buyerInfo=" + this.getBuyerInfo() + ", invoiceAmountInfo=" + this.getInvoiceAmountInfo() + ", operatorInfo=" + this.getOperatorInfo() + ", redLetterInfo=" + this.getRedLetterInfo() + ", invoiceDetailList=" + this.getInvoiceDetailList() + ")";
        }
    }

    public static class Request {
        private List<InvoiceInfo> invoiceInfos;

        public ValidateResult validate() {
            if (this.invoiceInfos == null || this.invoiceInfos.size() == 0) {
                return ValidateResult.fail("\u53d1\u7968\u5217\u8868\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ValidateResult result = ValidateResult.success();
            for (InvoiceInfo invoiceInfo : this.invoiceInfos) {
                ValidateResult validateResult = BasicValidator.validate(invoiceInfo);
                result = BasicValidator.mergeValidateResult(result, validateResult);
            }
            return result;
        }

        public List<InvoiceInfo> getInvoiceInfos() {
            return this.invoiceInfos;
        }

        public void setInvoiceInfos(List<InvoiceInfo> invoiceInfos) {
            this.invoiceInfos = invoiceInfos;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request other = (Request)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<InvoiceInfo> this$invoiceInfos = this.getInvoiceInfos();
            List<InvoiceInfo> other$invoiceInfos = other.getInvoiceInfos();
            return !(this$invoiceInfos == null ? other$invoiceInfos != null : !((Object)this$invoiceInfos).equals(other$invoiceInfos));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Request;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<InvoiceInfo> $invoiceInfos = this.getInvoiceInfos();
            result = result * 59 + ($invoiceInfos == null ? 43 : ((Object)$invoiceInfos).hashCode());
            return result;
        }

        public String toString() {
            return "AllElectricInvoiceBaseValidationModel.Request(invoiceInfos=" + this.getInvoiceInfos() + ")";
        }
    }
}

