/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.check.model.base;

import com.xforceplus.taxware.chestnut.check.model.common.Alias;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.ScriptAssert;

@ScriptAssert.List(value={@ScriptAssert(lang="javascript", script="com.xforceplus.taxware.chestnut.check.model.base.BaseDetail.isValidUnionInfo(_this)", message="\u6570\u91cf\uff0c\u5355\u4ef7\u548c\u5355\u4f4d\u6709\u4e00\u9879\u662f\u975e\u7a7a\uff0c\u5219\u53e6\u5916\u4e24\u9879\u4e5f\u8981\u975e\u7a7a")})
public class BaseDetail {
    @Alias(value="\u84dd\u5b57\u53d1\u7968\u660e\u7ec6\u5e8f\u53f7")
    @Digits(integer=8, fraction=0)
    private @Digits(integer=8, fraction=0) Integer originalRowNum;
    @Alias(value="\u5e8f\u53f7")
    @NotNull
    @Digits(integer=8, fraction=0)
    private @NotNull @Digits(integer=8, fraction=0) Integer rowNum;
    @Alias(value="\u5546\u54c1\u548c\u670d\u52a1\u7a0e\u6536\u5206\u7c7b\u5408\u5e76\u7f16\u7801")
    @NotEmpty
    @Length(max=19)
    private @NotEmpty @Length(max=19) String goodsTaxNo;
    @Alias(value="\u9879\u76ee\u540d\u79f0")
    @NotEmpty
    @Length(max=600)
    @Pattern(regexp="\\*.+?\\*.+")
    private @NotEmpty @Length(max=600) @Pattern(regexp="\\*.+?\\*.+") String itemName;
    @Alias(value="\u89c4\u683c\u578b\u53f7")
    @Length(max=150)
    private @Length(max=150) String specifications;
    @Alias(value="\u5355\u4f4d")
    @Length(max=300)
    private @Length(max=300) String unit;
    @Alias(value="\u5355\u4ef7")
    @Length(max=25)
    private @Length(max=25) String unitPrice;
    @Alias(value="\u6570\u91cf")
    @Length(max=25)
    private @Length(max=25) String quantity;
    @Alias(value="\u91d1\u989d")
    @NotNull
    @Digits(integer=18, fraction=2)
    private @NotNull @Digits(integer=18, fraction=2) BigDecimal amountWithoutTax;
    @Alias(value="\u7a0e\u7387")
    @NotNull
    @Digits(integer=16, fraction=6)
    private @NotNull @Digits(integer=16, fraction=6) BigDecimal taxRate;
    @Alias(value="\u7a0e\u989d")
    @NotNull
    @Digits(integer=18, fraction=2)
    private @NotNull @Digits(integer=18, fraction=2) BigDecimal taxAmount;

    public static boolean isValidUnionInfo(BaseDetail detail) {
        if (detail.getUnit() != null && detail.getUnit().trim().length() > 0 || detail.getUnitPrice() != null && detail.getUnitPrice().trim().length() > 0 || detail.getQuantity() != null && detail.getQuantity().trim().length() > 0) {
            return detail.getUnit() != null && detail.getUnit().trim().length() > 0 && detail.getUnitPrice() != null && detail.getUnitPrice().trim().length() > 0 && detail.getQuantity() != null && detail.getQuantity().trim().length() > 0;
        }
        return true;
    }

    public String getItemShortName() {
        if (StringUtils.isBlank((CharSequence)this.itemName)) {
            return null;
        }
        List<String> split = Arrays.asList(StringUtils.split((String)this.itemName, (String)"*"));
        ArrayList<String> spmcsm = new ArrayList<String>(split);
        if (spmcsm.size() < 2 && !this.itemName.startsWith("*")) {
            return null;
        }
        return spmcsm.get(0);
    }

    public Integer getOriginalRowNum() {
        return this.originalRowNum;
    }

    public Integer getRowNum() {
        return this.rowNum;
    }

    public String getGoodsTaxNo() {
        return this.goodsTaxNo;
    }

    public String getItemName() {
        return this.itemName;
    }

    public String getSpecifications() {
        return this.specifications;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getUnitPrice() {
        return this.unitPrice;
    }

    public String getQuantity() {
        return this.quantity;
    }

    public BigDecimal getAmountWithoutTax() {
        return this.amountWithoutTax;
    }

    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public BigDecimal getTaxAmount() {
        return this.taxAmount;
    }

    public void setOriginalRowNum(Integer originalRowNum) {
        this.originalRowNum = originalRowNum;
    }

    public void setRowNum(Integer rowNum) {
        this.rowNum = rowNum;
    }

    public void setGoodsTaxNo(String goodsTaxNo) {
        this.goodsTaxNo = goodsTaxNo;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public void setSpecifications(String specifications) {
        this.specifications = specifications;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setUnitPrice(String unitPrice) {
        this.unitPrice = unitPrice;
    }

    public void setQuantity(String quantity) {
        this.quantity = quantity;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseDetail)) {
            return false;
        }
        BaseDetail other = (BaseDetail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$originalRowNum = this.getOriginalRowNum();
        Integer other$originalRowNum = other.getOriginalRowNum();
        if (this$originalRowNum == null ? other$originalRowNum != null : !((Object)this$originalRowNum).equals(other$originalRowNum)) {
            return false;
        }
        Integer this$rowNum = this.getRowNum();
        Integer other$rowNum = other.getRowNum();
        if (this$rowNum == null ? other$rowNum != null : !((Object)this$rowNum).equals(other$rowNum)) {
            return false;
        }
        String this$goodsTaxNo = this.getGoodsTaxNo();
        String other$goodsTaxNo = other.getGoodsTaxNo();
        if (this$goodsTaxNo == null ? other$goodsTaxNo != null : !this$goodsTaxNo.equals(other$goodsTaxNo)) {
            return false;
        }
        String this$itemName = this.getItemName();
        String other$itemName = other.getItemName();
        if (this$itemName == null ? other$itemName != null : !this$itemName.equals(other$itemName)) {
            return false;
        }
        String this$specifications = this.getSpecifications();
        String other$specifications = other.getSpecifications();
        if (this$specifications == null ? other$specifications != null : !this$specifications.equals(other$specifications)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        String this$unitPrice = this.getUnitPrice();
        String other$unitPrice = other.getUnitPrice();
        if (this$unitPrice == null ? other$unitPrice != null : !this$unitPrice.equals(other$unitPrice)) {
            return false;
        }
        String this$quantity = this.getQuantity();
        String other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !this$quantity.equals(other$quantity)) {
            return false;
        }
        BigDecimal this$amountWithoutTax = this.getAmountWithoutTax();
        BigDecimal other$amountWithoutTax = other.getAmountWithoutTax();
        if (this$amountWithoutTax == null ? other$amountWithoutTax != null : !((Object)this$amountWithoutTax).equals(other$amountWithoutTax)) {
            return false;
        }
        BigDecimal this$taxRate = this.getTaxRate();
        BigDecimal other$taxRate = other.getTaxRate();
        if (this$taxRate == null ? other$taxRate != null : !((Object)this$taxRate).equals(other$taxRate)) {
            return false;
        }
        BigDecimal this$taxAmount = this.getTaxAmount();
        BigDecimal other$taxAmount = other.getTaxAmount();
        return !(this$taxAmount == null ? other$taxAmount != null : !((Object)this$taxAmount).equals(other$taxAmount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseDetail;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $originalRowNum = this.getOriginalRowNum();
        result = result * 59 + ($originalRowNum == null ? 43 : ((Object)$originalRowNum).hashCode());
        Integer $rowNum = this.getRowNum();
        result = result * 59 + ($rowNum == null ? 43 : ((Object)$rowNum).hashCode());
        String $goodsTaxNo = this.getGoodsTaxNo();
        result = result * 59 + ($goodsTaxNo == null ? 43 : $goodsTaxNo.hashCode());
        String $itemName = this.getItemName();
        result = result * 59 + ($itemName == null ? 43 : $itemName.hashCode());
        String $specifications = this.getSpecifications();
        result = result * 59 + ($specifications == null ? 43 : $specifications.hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        String $unitPrice = this.getUnitPrice();
        result = result * 59 + ($unitPrice == null ? 43 : $unitPrice.hashCode());
        String $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : $quantity.hashCode());
        BigDecimal $amountWithoutTax = this.getAmountWithoutTax();
        result = result * 59 + ($amountWithoutTax == null ? 43 : ((Object)$amountWithoutTax).hashCode());
        BigDecimal $taxRate = this.getTaxRate();
        result = result * 59 + ($taxRate == null ? 43 : ((Object)$taxRate).hashCode());
        BigDecimal $taxAmount = this.getTaxAmount();
        result = result * 59 + ($taxAmount == null ? 43 : ((Object)$taxAmount).hashCode());
        return result;
    }

    public String toString() {
        return "BaseDetail(originalRowNum=" + this.getOriginalRowNum() + ", rowNum=" + this.getRowNum() + ", goodsTaxNo=" + this.getGoodsTaxNo() + ", itemName=" + this.getItemName() + ", specifications=" + this.getSpecifications() + ", unit=" + this.getUnit() + ", unitPrice=" + this.getUnitPrice() + ", quantity=" + this.getQuantity() + ", amountWithoutTax=" + this.getAmountWithoutTax() + ", taxRate=" + this.getTaxRate() + ", taxAmount=" + this.getTaxAmount() + ")";
    }
}

