/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.check.model.validator.tax;

import com.xforceplus.taxware.architecture.g1.domain.exception.TXWR000004Exception;
import com.xforceplus.taxware.chestnut.check.model.base.TaxCode;
import com.xforceplus.taxware.chestnut.contract.model.constant.enums.TaxCodeStatusEnum;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class TaxCodeValidator {
    public static void validate(String itemName, TaxCode taxCode) {
        if (null == taxCode) {
            throw new TXWR000004Exception("\u7a0e\u7f16\u4e0d\u5b58\u5728\uff0c\u7981\u6b62\u5f00\u7968");
        }
        if (TaxCodeStatusEnum.TAX_RATE_STATUS_Y.getStatus().equals(taxCode.getSummarizeItemFlag())) {
            throw new TXWR000004Exception("\u8be5\u7a0e\u7f16\u662f\u6c47\u603b\u9879\uff0c\u7981\u6b62\u5f00\u7968");
        }
        if (!StringUtils.equals((CharSequence)taxCode.getItemShortName(), (CharSequence)itemName)) {
            throw new TXWR000004Exception("\u7a0e\u7f16\u6709\u8bef\uff0c\u7981\u6b62\u5f00\u7968");
        }
        Date now = Date.from(LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toInstant());
        Date startDate = taxCode.getStartDate();
        Date endDate = taxCode.getEndDate();
        if (null == startDate || startDate.compareTo(now) > 0) {
            throw new TXWR000004Exception("\u7a0e\u7f16\u4e0d\u5728\u6709\u6548\u671f\u8303\u56f4\u5185\uff0c\u7981\u6b62\u5f00\u7968");
        }
        if (null != endDate && endDate.compareTo(now) < 0) {
            throw new TXWR000004Exception("\u7a0e\u7f16\u4e0d\u5728\u6709\u6548\u671f\u8303\u56f4\u5185\uff0c\u7981\u6b62\u5f00\u7968");
        }
    }
}

