/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.check.model.validator.tax;

import com.xforceplus.taxware.architecture.g1.domain.exception.TXWR000004Exception;
import com.xforceplus.taxware.chestnut.check.model.base.BaseDetail;
import com.xforceplus.taxware.chestnut.check.model.base.TaxRate;
import com.xforceplus.taxware.chestnut.contract.model.constant.enums.TaxRateStatusEnum;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;

public class TaxRateValidator {
    public static void validate(List<BaseDetail> baseDetails, List<TaxRate> taxRateList) {
        baseDetails.stream().forEach(baseDetail -> {
            TaxRate taxRate = taxRateList.stream().filter(x -> baseDetail.getTaxRate().compareTo(x.getTaxRate()) == 0).findAny().orElseThrow(() -> new TXWR000004Exception(String.format("[%s]\u7a0e\u7387\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u7981\u6b62\u5f00\u7968", baseDetail.getTaxRate())));
            System.out.println(String.format("validator rate -> %s", taxRate));
            String paraFlag = taxRate.getParaFlag();
            if (!TaxRateStatusEnum.TAX_RATE_STATUS_0.getStatus().equals(paraFlag)) {
                throw new TXWR000004Exception(String.format("[%s]\u7a0e\u7387\u72b6\u6001\u505c\u7528\uff0c\u7981\u6b62\u5f00\u7968", taxRate.getTaxRate()));
            }
            Date now = Date.from(LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toInstant());
            Date startDate = taxRate.getStartDate();
            Date stopDate = taxRate.getStopDate();
            Date endDate = taxRate.getEndDate();
            if (null == startDate || startDate.compareTo(now) > 0) {
                throw new TXWR000004Exception(String.format("[%s]\u7a0e\u7387\u72b6\u6001\u505c\u7528\uff0c\u7981\u6b62\u5f00\u7968", taxRate.getTaxRate()));
            }
            if (null != stopDate && stopDate.compareTo(now) < 0) {
                throw new TXWR000004Exception(String.format("[%s]\u7a0e\u7387\u4e0d\u5728\u6709\u6548\u671f\u8303\u56f4\u5185\uff0c\u7981\u6b62\u5f00\u7968", taxRate.getTaxRate()));
            }
            if (null != endDate && endDate.compareTo(now) < 0) {
                throw new TXWR000004Exception(String.format("[%s]\u7a0e\u7387\u5df2\u505c\u7528\uff0c\u7981\u6b62\u5f00\u7968", taxRate.getTaxRate()));
            }
        });
    }
}

