package com.xforceplus.taxware.chestnut.check.model.base;

import com.xforceplus.taxware.chestnut.check.model.common.Alias;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * @author Thj
 * @createdAt: 2023/2/8 16:39
 * @Description:
 */
@Data
public class RedLetterInfo {

    /**
     * 对应蓝字发票号码（非必须）
     */
    @Alias("对应蓝字发票号码")
    @Length(max = 20)
    private String originalInvoiceNo;

    /**
     * 原蓝票开具日期
     * TODO 是否增加确认
     */
    private String originalDateIssued;

    /**
     * 红字确认信息单编号（非必须）
     * 是否蓝字发票标志为1时，此节点有内容
     * 红票开具时必传
     */
    @Alias("红字确认信息单编号")
    @Length(max = 20)
    private String redLetterNumber;
}
