package com.xforceplus.taxware.chestnut.check.model.base;


import lombok.Data;

import java.util.Date;

/**
 * @Auther lv
 * @Date 2023/2/20
 */
@Data
public class TaxpayerRiskInfo {

    /**
     * 纳税人识别号/统一社会信用代码
     */
    private String taxNo;

    /**
     * 风险纳税人类型（非必须）
     * 空：非风险纳税人
     * 01：Ⅰ类（高风险）纳税人
     * 02：Ⅱ类（中风险）纳税人
     * 03：Ⅲ类（低风险）纳税人
     * 04：Ⅳ类（无风险）纳税人
     */
    private String taxpayerRiskType;

    /**
     * 纳税人信用等级
     * A
     * B
     * C
     * D
     * M
     */
    private String taxpayerRiskLevel;

    /**
     * 纳税人预警级别（非必须）
     * 空：无预警
     * 01：红色预警
     * 02：黄色预警
     * 03：蓝色预警
     */
    private String taxpayerWarningLevel;

    /**
     * 风险纳税人标志
     * Y：风险纳税人
     * N：正常纳税人
     */
    private String taxpayerRiskFlag;
}
