package com.xforceplus.taxware.chestnut.check.model.validator.invoice;

import cn.hutool.core.bean.BeanUtil;
import com.xforceplus.taxware.architecture.g1.domain.exception.TXWR000002Exception;
import com.xforceplus.taxware.chestnut.check.model.base.BaseDetail;
import com.xforceplus.taxware.chestnut.check.model.validator.redletter.RedLetterValidator;
import org.apache.commons.collections4.CollectionUtils;

import java.util.Comparator;
import java.util.Objects;

/**
 * @Auther lv
 * @Date 2023/2/16
 * @Descrption 红票开具时：发票信息与红字确认单比对
 * 红字发票明细和红字确认单必须保持一致
 */
public class RedInvoiceVsRedLetterValidator {

    //        //以异常形式抛出
//        throw new TXWR000002Exception("第*行 金额不一致");
    public static void validate(final InvoiceBaseValidator invoiceBase, final RedLetterValidator redLetter) {

        if (CollectionUtils.isEmpty(invoiceBase.getInvoiceDetailList()) || CollectionUtils.isEmpty(redLetter.getDetails())) {
            throw new TXWR000002Exception("明细行数据不能为空");
        }

        // 排序
        invoiceBase.getInvoiceDetailList().sort(Comparator.comparing(InvoiceBaseValidator.InvoiceDetail::getRowNum));
        redLetter.getDetails().sort(Comparator.comparing(RedLetterValidator.Detail::getRowNum));

        String errorMsgFormat = "红票和红字确认单第%s行明细存在不相等的信息";
        for (int i = 0; i < invoiceBase.getInvoiceDetailList().size(); i++) {
            //todo-rayder 更优解待定
            BaseDetail invoiceDetail = invoiceBase.getInvoiceDetailList().get(i);
            BaseDetail invoiceDetailBase = new BaseDetail();
            BeanUtil.copyProperties(invoiceDetail, invoiceDetailBase);

            BaseDetail redletterDetail = redLetter.getDetails().get(i);
            BaseDetail redletterDetailBase = new BaseDetail();
            BeanUtil.copyProperties(redletterDetail, redletterDetailBase);

            if (!Objects.equals(invoiceDetailBase, redletterDetailBase)) {
                throw new TXWR000002Exception(String.format(errorMsgFormat, i + 1));
            }
        }

    }

}
